/*
 * Decompiled with CFR 0.152.
 */
package gcspawners;

import gc.spawners.Core;
import gc.spawners.handlers.customSpawners.AdvancedSpawnerData;
import gc.spawners.handlers.dropsHandler.EntityDrops;
import gc.spawners.handlers.mobs.objects.AdvancedEntity;
import java.util.ArrayList;
import java.util.List;
import net.advancedplugins.utils.nbt.NBTapi;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;

public class ASAPI {
    public static EntityDrops getCustomDrops(String entType) {
        AdvancedEntity ent = Core.getMatcher().getEntity(entType);
        if (ent == null) {
            return null;
        }
        return ent.getEntityDrops();
    }

    public static ItemStack getMobSkull(String mobName) {
        return Core.getHeadHandler().getHead(mobName);
    }

    public static int getSpawnerLevel(Block b) {
        return Core.getSpawnersHandler().getSpawner(b.getLocation()).getLevel();
    }

    public static String getSpawnerType(Block b) {
        return Core.getSpawnersHandler().getSpawner(b.getLocation()).getEntityType();
    }

    public static int getSpawnerAmount(Block b) {
        try {
            return Core.getSpawnersHandler().getSpawner(b.getLocation()).getStackCount(null);
        }
        catch (Exception ev) {
            return 1;
        }
    }

    public static void spawnCustomMob(Location loc, String customMob) {
        Core.getEntityHandler().spawnEntity(loc, customMob);
    }

    public static void setSpawnerAmount(Block b, int amount) {
        AdvancedSpawnerData data = Core.getSpawnersHandler().getSpawner(b.getLocation());
        data.setStackCount(amount);
        data.update();
    }

    public static void removeSpawner(Location loc) {
        try {
            Core.getSpawnersHandler().removeSpawner(loc);
        }
        catch (Exception ev) {
            ev.printStackTrace();
        }
    }

    public static int getSpawnerLevel(Location b) {
        return Core.getSpawnersHandler().getSpawner(b).getLevel();
    }

    public static String getSpawnerType(Location b) {
        try {
            return Core.getSpawnersHandler().getSpawner(b).getEntityType();
        }
        catch (Exception ev) {
            return "PIG";
        }
    }

    public static int getSpawnerAmount(Location b) {
        try {
            return Core.getSpawnersHandler().getSpawner(b).getStackCount(null);
        }
        catch (Exception ev) {
            return 0;
        }
    }

    public static void setSpawnerAmount(Location b, int amount) {
        AdvancedSpawnerData data = Core.getSpawnersHandler().getSpawner(b);
        data.setStackCount(amount);
        data.update();
    }

    public static String getSpawnerType(ItemStack item) {
        return NBTapi.contains((String)"spawnerType", (ItemStack)item) ? NBTapi.getEntity((ItemStack)item) : null;
    }

    public static List<String> getCustomMobs() {
        ArrayList<String> names = new ArrayList<String>();
        Core.getEntityHandler().getEntities().forEach(e -> names.add(e.getEntityMeta().getEntityType()));
        return names;
    }

    public static String getUser() {
        return "%%__USER__%%";
    }
}

