/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.data;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class GamePlayerData {
    private final String name;
    private int kills;
    private int deaths;
    private int finalKills;
    private int bedDestroys;
    @NotNull
    private List<ItemStack> inventory = new ArrayList<ItemStack>();

    public static GamePlayerData of(@NotNull Player player) {
        return new GamePlayerData(player.getName());
    }

    private GamePlayerData(String name) {
        this.name = name;
    }

    public static GamePlayerData of(String name) {
        return new GamePlayerData(name);
    }

    public String getName() {
        return this.name;
    }

    public int getKills() {
        return this.kills;
    }

    public int getDeaths() {
        return this.deaths;
    }

    public int getFinalKills() {
        return this.finalKills;
    }

    public int getBedDestroys() {
        return this.bedDestroys;
    }

    @NotNull
    public List<ItemStack> getInventory() {
        return this.inventory;
    }

    public void setKills(int kills) {
        this.kills = kills;
    }

    public void setDeaths(int deaths) {
        this.deaths = deaths;
    }

    public void setFinalKills(int finalKills) {
        this.finalKills = finalKills;
    }

    public void setBedDestroys(int bedDestroys) {
        this.bedDestroys = bedDestroys;
    }

    public void setInventory(@NotNull List<ItemStack> inventory) {
        if (inventory == null) {
            throw new NullPointerException("inventory is marked non-null but is null");
        }
        this.inventory = inventory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GamePlayerData)) {
            return false;
        }
        GamePlayerData other = (GamePlayerData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getKills() != other.getKills()) {
            return false;
        }
        if (this.getDeaths() != other.getDeaths()) {
            return false;
        }
        if (this.getFinalKills() != other.getFinalKills()) {
            return false;
        }
        if (this.getBedDestroys() != other.getBedDestroys()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<ItemStack> this$inventory = this.getInventory();
        List<ItemStack> other$inventory = other.getInventory();
        return !(this$inventory == null ? other$inventory != null : !((Object)this$inventory).equals(other$inventory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GamePlayerData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getKills();
        result = result * 59 + this.getDeaths();
        result = result * 59 + this.getFinalKills();
        result = result * 59 + this.getBedDestroys();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<ItemStack> $inventory = this.getInventory();
        result = result * 59 + ($inventory == null ? 43 : ((Object)$inventory).hashCode());
        return result;
    }

    public String toString() {
        return "GamePlayerData(name=" + this.getName() + ", kills=" + this.getKills() + ", deaths=" + this.getDeaths() + ", finalKills=" + this.getFinalKills() + ", bedDestroys=" + this.getBedDestroys() + ", inventory=" + this.getInventory() + ")";
    }
}

