/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.wrapper;

import com.google.common.base.Strings;
import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.screaminglib.player.ExtendablePlayerWrapper;
import io.github.pronze.lib.screaminglib.player.PlayerMapper;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.sender.CommandSenderWrapper;
import io.github.pronze.sba.AddonAPI;
import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.Permissions;
import io.github.pronze.sba.data.ToggleableSetting;
import io.github.pronze.sba.wrapper.PlayerSetting;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.statistics.PlayerStatistic;

public class SBAPlayerWrapper
extends ExtendablePlayerWrapper {
    private int shoutCooldown = 0;
    private final ToggleableSetting<PlayerSetting> settings = ToggleableSetting.of(PlayerSetting.class);

    public SBAPlayerWrapper(Player player) {
        super((PlayerWrapper)PlayerMapper.getPlayer((UUID)player.getUniqueId()).get());
    }

    public void sendMessage(String message) {
        this.getInstance().sendMessage(message);
    }

    public Player getInstance() {
        return (Player)this.as(Player.class);
    }

    public boolean canShout() {
        return this.shoutCooldown == 0;
    }

    public void shout(Component message) {
        if (this.shoutCooldown == 0) {
            this.sendMessage(message);
            if (this.getInstance().hasPermission(Permissions.SHOUT_BYPASS.getKey()) || SBAPlayerWrapper.getDefaultShoutCoolDownTime() == 0) {
                return;
            }
            this.shoutCooldown = SBAPlayerWrapper.getDefaultShoutCoolDownTime();
            new BukkitRunnable(){

                public void run() {
                    --SBAPlayerWrapper.this.shoutCooldown;
                    if (SBAPlayerWrapper.this.shoutCooldown == 0) {
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)AddonAPI.getInstance().getJavaPlugin(), 0L, 20L);
        } else {
            AddonAPI.getInstance().getLanguageService().get(MessageKeys.MESSAGE_SHOUT_WAIT).replace("%seconds%", String.valueOf(this.getShoutCooldown())).send(new CommandSenderWrapper[]{this});
        }
    }

    public int getXP() {
        PlayerStatistic statistic = Main.getPlayerStatisticsManager().getStatistic((OfflinePlayer)this.getInstance());
        if (statistic == null) {
            statistic = Main.getPlayerStatisticsManager().loadStatistic(this.getUuid());
            if (statistic != null) {
                return statistic.getScore();
            }
            return 1;
        }
        return statistic.getScore();
    }

    public int getLevel() {
        int xp = this.getXP();
        if (xp < SBAPlayerWrapper.getTotalXPToLevelUp()) {
            return 1;
        }
        return 1 + xp / SBAPlayerWrapper.getTotalXPToLevelUp();
    }

    public String getProgress() {
        int maxLimit = SBAPlayerWrapper.getTotalXPToLevelUp();
        String format = AddonAPI.getInstance().getConfigurator().getString("main-lobby.progress-format", "\u00a7b%progress%\u00a77/\u00a7a%total%").replace("%total%", SBAPlayerWrapper.round(maxLimit));
        int progress = this.getXP() - (this.getLevel() - 1) * maxLimit;
        if (progress <= 0) {
            progress = 0;
        }
        return format.replace("%progress%", SBAPlayerWrapper.round(progress));
    }

    public int getIntegerProgress() {
        return (this.getXP() - (this.getLevel() - 1) * SBAPlayerWrapper.getTotalXPToLevelUp()) / SBAPlayerWrapper.getTotalXPToLevelUp() * 100;
    }

    public String getCompletedBoxes() {
        int progress = this.getIntegerProgress();
        if (progress < 1) {
            progress = 1;
        }
        int numberOfBoxesFilled = progress / 10;
        return "\u00a77[\u00a7b" + Strings.repeat((String)"\u25a0", (int)numberOfBoxesFilled) + "\u00a77" + Strings.repeat((String)"\u25a0", (int)(10 - numberOfBoxesFilled)) + "]";
    }

    protected static String round(double toRound) {
        if (toRound >= 1000.0) {
            BigDecimal bd = new BigDecimal(String.valueOf(toRound / 1000.0));
            bd = bd.setScale(1, RoundingMode.HALF_DOWN);
            return bd.doubleValue() + "k";
        }
        return String.valueOf(toRound);
    }

    protected static String round(int toRound) {
        return SBAPlayerWrapper.round((double)toRound);
    }

    public static int getTotalXPToLevelUp() {
        return AddonAPI.getInstance().getConfigurator().getInt("player-statistics.xp-to-level-up", 5000);
    }

    protected static int getDefaultShoutCoolDownTime() {
        return AddonAPI.getInstance().getConfigurator().getInt("shout.time-out", 60);
    }

    public int getShoutCooldown() {
        return this.shoutCooldown;
    }

    public ToggleableSetting<PlayerSetting> getSettings() {
        return this.settings;
    }

    public void setShoutCooldown(int shoutCooldown) {
        this.shoutCooldown = shoutCooldown;
    }
}

