/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.cloud.annotations;

import io.github.pronze.lib.cloud.annotations.AnnotationParser;
import io.github.pronze.lib.cloud.arguments.parser.ParserParameters;
import io.github.pronze.lib.cloud.meta.CommandMeta;
import java.lang.reflect.Method;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;

class MetaFactory
implements Function<Method, CommandMeta> {
    private final AnnotationParser<?> annotationParser;
    private final Function<ParserParameters, CommandMeta> metaMapper;

    MetaFactory(@NonNull AnnotationParser<?> annotationParser, @NonNull Function<@NonNull ParserParameters, @NonNull CommandMeta> metaMapper) {
        this.annotationParser = annotationParser;
        this.metaMapper = metaMapper;
    }

    @Override
    public @NonNull CommandMeta apply(@NonNull Method method) {
        ParserParameters parameters = ParserParameters.empty();
        this.annotationParser.getAnnotationMappers().forEach((annotationClass, mapper) -> {
            Object annotation = AnnotationParser.getMethodOrClassAnnotation(method, annotationClass);
            if (annotation != null) {
                parameters.merge((ParserParameters)mapper.apply(annotation));
            }
        });
        return this.metaMapper.apply(parameters);
    }
}

