/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.cloud.annotations.parsers;

import io.github.pronze.lib.cloud.arguments.parser.ArgumentParseResult;
import io.github.pronze.lib.cloud.arguments.parser.ArgumentParser;
import io.github.pronze.lib.cloud.context.CommandContext;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class MethodArgumentParser<C, T>
implements ArgumentParser<C, T> {
    private final BiFunction<CommandContext<C>, String, List<String>> suggestionProvider;
    private final MethodHandle methodHandle;

    public MethodArgumentParser(@NonNull BiFunction<CommandContext<C>, String, List<String>> suggestionProvider, @NonNull Object instance, @NonNull Method method) throws Exception {
        this.suggestionProvider = suggestionProvider;
        this.methodHandle = MethodHandles.lookup().unreflect(method).bindTo(instance);
    }

    @Override
    public @NonNull ArgumentParseResult<@NonNull T> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
        try {
            return ArgumentParseResult.success(this.methodHandle.invokeWithArguments(commandContext, inputQueue));
        }
        catch (Throwable t) {
            return ArgumentParseResult.failure(t);
        }
    }

    @Override
    public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
        return this.suggestionProvider.apply(commandContext, input);
    }
}

