/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.cloud.brigadier.argument;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.pronze.lib.cloud.arguments.parser.ArgumentParseResult;
import io.github.pronze.lib.cloud.arguments.parser.ArgumentParser;
import io.github.pronze.lib.cloud.brigadier.argument.QueueAsStringReader;
import io.github.pronze.lib.cloud.brigadier.argument.StringReaderAsQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class WrappedBrigadierParser<C, T>
implements ArgumentParser<C, T> {
    public static final String COMMAND_CONTEXT_BRIGADIER_NATIVE_SENDER = "_cloud_brigadier_native_sender";
    private final ArgumentType<T> nativeType;
    private final int expectedArgumentCount;

    public WrappedBrigadierParser(ArgumentType<T> nativeType) {
        this(nativeType, 1);
    }

    public WrappedBrigadierParser(ArgumentType<T> nativeType, int expectedArgumentCount) {
        this.nativeType = Objects.requireNonNull(nativeType, "brigadierType");
        this.expectedArgumentCount = expectedArgumentCount;
    }

    public ArgumentType<T> getNativeArgument() {
        return this.nativeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull ArgumentParseResult<@NonNull T> parse(@NonNull io.github.pronze.lib.cloud.context.CommandContext<@NonNull C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
        Object reader = inputQueue instanceof StringReader ? (StringReader)inputQueue : (inputQueue instanceof StringReaderAsQueue ? ((StringReaderAsQueue)inputQueue).getOriginal() : new QueueAsStringReader(inputQueue));
        try {
            ArgumentParseResult<Object> argumentParseResult = ArgumentParseResult.success(this.nativeType.parse(reader));
            return argumentParseResult;
        }
        catch (CommandSyntaxException ex) {
            ArgumentParseResult argumentParseResult = ArgumentParseResult.failure(ex);
            return argumentParseResult;
        }
        finally {
            if (reader instanceof QueueAsStringReader) {
                ((QueueAsStringReader)((Object)reader)).updateQueue();
            }
        }
    }

    @Override
    public @NonNull List<@NonNull String> suggestions(@NonNull io.github.pronze.lib.cloud.context.CommandContext<C> commandContext, @NonNull String input) {
        CommandContext reverseMappedContext = new CommandContext(commandContext.getOrDefault(COMMAND_CONTEXT_BRIGADIER_NATIVE_SENDER, commandContext.getSender()), commandContext.getRawInputJoined(), Collections.emptyMap(), null, null, Collections.emptyList(), StringRange.at((int)0), null, null, false);
        CompletableFuture result = this.nativeType.listSuggestions(reverseMappedContext, new SuggestionsBuilder(input, 0));
        List suggestions = ((Suggestions)result.join()).getList();
        ArrayList<String> out = new ArrayList<String>(suggestions.size());
        for (Suggestion suggestion : suggestions) {
            out.add(suggestion.getText());
        }
        return out;
    }

    @Override
    public boolean isContextFree() {
        return true;
    }

    @Override
    public int getRequestedArgumentCount() {
        return this.expectedArgumentCount;
    }
}

