/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.cloud.bukkit.parsers.selector;

import com.google.common.collect.ImmutableList;
import io.github.pronze.lib.cloud.ArgumentDescription;
import io.github.pronze.lib.cloud.arguments.CommandArgument;
import io.github.pronze.lib.cloud.arguments.parser.ArgumentParseResult;
import io.github.pronze.lib.cloud.arguments.parser.ArgumentParser;
import io.github.pronze.lib.cloud.bukkit.BukkitCommandContextKeys;
import io.github.pronze.lib.cloud.bukkit.CloudBukkitCapabilities;
import io.github.pronze.lib.cloud.bukkit.arguments.selector.MultiplePlayerSelector;
import io.github.pronze.lib.cloud.bukkit.parsers.PlayerArgument;
import io.github.pronze.lib.cloud.bukkit.parsers.selector.SelectorParseException;
import io.github.pronze.lib.cloud.context.CommandContext;
import io.github.pronze.lib.cloud.exceptions.parsing.NoInputProvidedException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class MultiplePlayerSelectorArgument<C>
extends CommandArgument<C, MultiplePlayerSelector> {
    private MultiplePlayerSelectorArgument(boolean required, @NonNull String name, @NonNull String defaultValue, @Nullable BiFunction<@NonNull CommandContext<C>, @NonNull String, @NonNull List<@NonNull String>> suggestionsProvider, @NonNull ArgumentDescription defaultDescription) {
        super(required, name, new MultiplePlayerSelectorParser(), defaultValue, MultiplePlayerSelector.class, suggestionsProvider, defaultDescription);
    }

    public static <C> Builder<C> newBuilder(@NonNull String name) {
        return new Builder(name);
    }

    public static <C> @NonNull CommandArgument<C, MultiplePlayerSelector> of(@NonNull String name) {
        return MultiplePlayerSelectorArgument.newBuilder(name).asRequired().build();
    }

    public static <C> @NonNull CommandArgument<C, MultiplePlayerSelector> optional(@NonNull String name) {
        return MultiplePlayerSelectorArgument.newBuilder(name).asOptional().build();
    }

    public static <C> @NonNull CommandArgument<C, MultiplePlayerSelector> optional(@NonNull String name, @NonNull String defaultEntitySelector) {
        return MultiplePlayerSelectorArgument.newBuilder(name).asOptionalWithDefault(defaultEntitySelector).build();
    }

    public static final class MultiplePlayerSelectorParser<C>
    implements ArgumentParser<C, MultiplePlayerSelector> {
        @Override
        public @NonNull ArgumentParseResult<MultiplePlayerSelector> parse(@NonNull CommandContext<C> commandContext, @NonNull Queue<@NonNull String> inputQueue) {
            List entities;
            String input = inputQueue.peek();
            if (input == null) {
                return ArgumentParseResult.failure(new NoInputProvidedException(MultiplePlayerSelectorParser.class, commandContext));
            }
            inputQueue.remove();
            if (!commandContext.get(BukkitCommandContextKeys.CLOUD_BUKKIT_CAPABILITIES).contains((Object)CloudBukkitCapabilities.BRIGADIER)) {
                Player player = Bukkit.getPlayer((String)input);
                if (player == null) {
                    return ArgumentParseResult.failure(new PlayerArgument.PlayerParseException(input, commandContext));
                }
                return ArgumentParseResult.success(new MultiplePlayerSelector(input, (List<Entity>)ImmutableList.of((Object)player)));
            }
            try {
                entities = Bukkit.selectEntities((CommandSender)commandContext.get(BukkitCommandContextKeys.BUKKIT_COMMAND_SENDER), (String)input);
            }
            catch (IllegalArgumentException e) {
                return ArgumentParseResult.failure(new SelectorParseException(input, commandContext, SelectorParseException.FailureReason.MALFORMED_SELECTOR, MultiplePlayerSelectorParser.class));
            }
            for (Entity e : entities) {
                if (e instanceof Player) continue;
                return ArgumentParseResult.failure(new SelectorParseException(input, commandContext, SelectorParseException.FailureReason.NON_PLAYER_IN_PLAYER_SELECTOR, MultiplePlayerSelectorParser.class));
            }
            return ArgumentParseResult.success(new MultiplePlayerSelector(input, entities));
        }

        @Override
        public @NonNull List<@NonNull String> suggestions(@NonNull CommandContext<C> commandContext, @NonNull String input) {
            ArrayList<String> output = new ArrayList<String>();
            for (Player player : Bukkit.getOnlinePlayers()) {
                CommandSender bukkit = commandContext.get(BukkitCommandContextKeys.BUKKIT_COMMAND_SENDER);
                if (bukkit instanceof Player && !((Player)bukkit).canSee(player)) continue;
                output.add(player.getName());
            }
            return output;
        }
    }

    public static final class Builder<C>
    extends CommandArgument.Builder<C, MultiplePlayerSelector> {
        private Builder(@NonNull String name) {
            super(MultiplePlayerSelector.class, name);
        }

        public @NonNull MultiplePlayerSelectorArgument<C> build() {
            return new MultiplePlayerSelectorArgument(this.isRequired(), this.getName(), this.getDefaultValue(), this.getSuggestionsProvider(), this.getDefaultDescription());
        }
    }
}

