/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.cloud.paper;

import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import io.github.pronze.lib.cloud.bukkit.BukkitPluginRegistrationHandler;
import io.github.pronze.lib.cloud.paper.PaperCommandManager;
import java.util.ArrayList;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.checkerframework.checker.nullness.qual.NonNull;

final class AsyncCommandSuggestionsListener<C>
implements Listener {
    private final PaperCommandManager<C> paperCommandManager;

    AsyncCommandSuggestionsListener(@NonNull PaperCommandManager<C> paperCommandManager) {
        this.paperCommandManager = paperCommandManager;
    }

    @EventHandler
    void onTabCompletion(@NonNull AsyncTabCompleteEvent event) {
        String commandLabel;
        if (event.getBuffer().trim().isEmpty()) {
            return;
        }
        BukkitPluginRegistrationHandler bukkitPluginRegistrationHandler = (BukkitPluginRegistrationHandler)this.paperCommandManager.getCommandRegistrationHandler();
        if (!bukkitPluginRegistrationHandler.isRecognized(commandLabel = (event.getBuffer().startsWith("/") ? event.getBuffer().substring(1) : event.getBuffer()).split(" ")[0])) {
            return;
        }
        CommandSender sender = event.getSender();
        Object cloudSender = this.paperCommandManager.getCommandSenderMapper().apply(sender);
        String inputBuffer = this.paperCommandManager.stripNamespace(event.getBuffer());
        ArrayList<String> suggestions = new ArrayList<String>(this.paperCommandManager.suggest(cloudSender, inputBuffer));
        event.setCompletions(suggestions);
        event.setHandled(true);
    }
}

