/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.kyori.adventure.serializer.configurate4;

import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.configurate.serialize.TypeSerializer;
import io.github.pronze.lib.kyori.adventure.key.Key;
import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.event.HoverEvent;
import java.lang.reflect.Type;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class HoverEventShowEntitySerializer
implements TypeSerializer<HoverEvent.ShowEntity> {
    static final HoverEventShowEntitySerializer INSTANCE = new HoverEventShowEntitySerializer();
    static final String ENTITY_TYPE = "type";
    static final String ID = "id";
    static final String NAME = "name";

    private HoverEventShowEntitySerializer() {
    }

    @Override
    public HoverEvent.ShowEntity deserialize(@NotNull Type type, @NotNull ConfigurationNode value) throws SerializationException {
        Key typeId = value.node(ENTITY_TYPE).get(Key.class);
        UUID id = value.node(ID).get(UUID.class);
        if (typeId == null || id == null) {
            throw new SerializationException("A show entity hover event needs type and id fields to be deserialized");
        }
        @Nullable Component name = value.node(NAME).get(Component.class);
        return HoverEvent.ShowEntity.of(typeId, id, name);
    }

    @Override
    public void serialize(@NotNull Type type, @Nullable HoverEvent.ShowEntity obj, @NotNull ConfigurationNode value) throws SerializationException {
        if (obj == null) {
            value.set(null);
            return;
        }
        value.node(ENTITY_TYPE).set(Key.class, obj.type());
        value.node(ID).set(UUID.class, obj.id());
        value.node(NAME).set(Component.class, obj.name());
    }
}

