/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.kyori.adventure.serializer.configurate4;

import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.configurate.serialize.TypeSerializer;
import io.github.pronze.lib.kyori.adventure.key.Key;
import io.github.pronze.lib.kyori.adventure.nbt.api.BinaryTagHolder;
import io.github.pronze.lib.kyori.adventure.text.event.HoverEvent;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class HoverEventShowItemSerializer
implements TypeSerializer<HoverEvent.ShowItem> {
    static final HoverEventShowItemSerializer INSTANCE = new HoverEventShowItemSerializer();
    static final String ID = "id";
    static final String COUNT = "count";
    static final String TAG = "tag";

    private HoverEventShowItemSerializer() {
    }

    @Override
    public HoverEvent.ShowItem deserialize(@NotNull Type type, @NotNull ConfigurationNode value) throws SerializationException {
        Key id = value.node(ID).get(Key.class);
        if (id == null) {
            throw new SerializationException("An id is required to deserialize the show_item hover event");
        }
        int count = value.node(COUNT).getInt(1);
        String tag = value.node(TAG).getString();
        return HoverEvent.ShowItem.of(id, count, tag == null ? null : BinaryTagHolder.of(tag));
    }

    @Override
    public void serialize(@NotNull Type type, @Nullable HoverEvent.ShowItem obj, @NotNull ConfigurationNode value) throws SerializationException {
        if (obj == null) {
            value.set(null);
            return;
        }
        value.node(ID).set(Key.class, obj.item());
        value.node(COUNT).set(obj.count());
        if (obj.nbt() == null) {
            value.node(TAG).set(null);
        } else {
            value.node(TAG).set(obj.nbt().string());
        }
    }
}

