/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.kyori.adventure.serializer.configurate4;

import io.github.pronze.lib.configurate.serialize.CoercionFailedException;
import io.github.pronze.lib.configurate.serialize.ScalarSerializer;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.kyori.adventure.key.InvalidKeyException;
import io.github.pronze.lib.kyori.adventure.key.Key;
import java.lang.reflect.Type;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

final class KeySerializer
extends ScalarSerializer<Key> {
    static final KeySerializer INSTANCE = new KeySerializer();

    private KeySerializer() {
        super(Key.class);
    }

    @Override
    @NotNull
    public Key deserialize(@NotNull Type type, @NotNull Object obj) throws SerializationException {
        if (!(obj instanceof CharSequence)) {
            throw new CoercionFailedException(obj, "string");
        }
        try {
            return Key.key(obj.toString());
        }
        catch (InvalidKeyException ex) {
            throw new SerializationException(ex);
        }
    }

    @Override
    @NotNull
    public Object serialize(@NotNull Key item, @NotNull Predicate<Class<?>> typeSupported) {
        return item.asString();
    }
}

