/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.kyori.adventure.serializer.configurate4;

import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.configurate.serialize.TypeSerializer;
import io.github.pronze.lib.kyori.adventure.key.Key;
import io.github.pronze.lib.kyori.adventure.sound.Sound;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SoundSerializer
implements TypeSerializer<Sound> {
    static final SoundSerializer INSTANCE = new SoundSerializer();
    static final String NAME = "name";
    static final String SOURCE = "source";
    static final String PITCH = "pitch";
    static final String VOLUME = "volume";

    private SoundSerializer() {
    }

    @Override
    @Nullable
    public Sound deserialize(@NotNull Type type, @NotNull ConfigurationNode value) throws SerializationException {
        if (value.empty()) {
            return null;
        }
        Key name = value.node(NAME).get(Key.class);
        Sound.Source source = value.node(SOURCE).get(Sound.Source.class);
        float volume = value.node(VOLUME).getFloat(1.0f);
        float pitch = value.node(PITCH).getFloat(1.0f);
        if (name == null || source == null) {
            throw new SerializationException("A name and source are required to deserialize a Sound");
        }
        return Sound.sound(name, source, volume, pitch);
    }

    @Override
    public void serialize(@NotNull Type type, @Nullable Sound obj, @NotNull ConfigurationNode value) throws SerializationException {
        if (obj == null) {
            value.set(null);
            return;
        }
        value.node(NAME).set(Key.class, obj.name());
        value.node(SOURCE).set(Sound.Source.class, obj.source());
        value.node(VOLUME).set(Float.valueOf(obj.volume()));
        value.node(PITCH).set(Float.valueOf(obj.pitch()));
    }
}

