/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.kyori.adventure.serializer.configurate4;

import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.configurate.serialize.TypeSerializer;
import io.github.pronze.lib.kyori.adventure.key.Key;
import io.github.pronze.lib.kyori.adventure.sound.Sound;
import io.github.pronze.lib.kyori.adventure.sound.SoundStop;
import java.lang.reflect.Type;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SoundStopSerializer
implements TypeSerializer<SoundStop> {
    static final SoundStopSerializer INSTANCE = new SoundStopSerializer();
    static final String SOUND = "sound";
    static final String SOURCE = "source";

    private SoundStopSerializer() {
    }

    @Override
    public SoundStop deserialize(@NotNull Type type, @NotNull ConfigurationNode value) throws SerializationException {
        if (value.empty()) {
            return SoundStop.all();
        }
        Key sound = value.node(SOUND).get(Key.class);
        Sound.Source source = value.node(SOURCE).get(Sound.Source.class);
        if (sound == null) {
            return source == null ? SoundStop.all() : SoundStop.source(source);
        }
        return source == null ? SoundStop.named(sound) : SoundStop.namedOnSource(sound, source);
    }

    @Override
    public void serialize(@NotNull Type type, @Nullable SoundStop obj, @NotNull ConfigurationNode value) throws SerializationException {
        value.node(SOUND).set(Key.class, obj == null ? null : obj.sound());
        value.node(SOURCE).set(Sound.Source.class, obj == null ? null : obj.source());
        if (value.empty()) {
            value.set(Collections.emptyMap());
        }
    }
}

