/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.kyori.adventure.serializer.configurate4;

import io.github.pronze.lib.configurate.serialize.ScalarSerializer;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.kyori.adventure.text.format.NamedTextColor;
import io.github.pronze.lib.kyori.adventure.text.format.TextColor;
import java.lang.reflect.Type;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

final class TextColorSerializer
extends ScalarSerializer<TextColor> {
    static final TextColorSerializer INSTANCE = new TextColorSerializer();
    private static final String HEX_PREFIX = "#";

    private TextColorSerializer() {
        super(TextColor.class);
    }

    @Override
    public TextColor deserialize(@NotNull Type type, @NotNull Object obj) throws SerializationException {
        if (obj instanceof Number) {
            return TextColor.color(((Number)obj).intValue());
        }
        if (!(obj instanceof CharSequence)) {
            throw new SerializationException("Text colors must either be strings or integers");
        }
        String value = obj.toString();
        TextColor result = value.startsWith(HEX_PREFIX) ? TextColor.fromHexString(value) : (TextColor)NamedTextColor.NAMES.value(value);
        if (result == null) {
            throw new SerializationException("Could not convert '" + value + "' into a TextColor");
        }
        return result;
    }

    @Override
    public Object serialize(@NotNull TextColor item, @NotNull Predicate<Class<?>> typeSupported) {
        if (item instanceof NamedTextColor) {
            return NamedTextColor.NAMES.key((NamedTextColor)item);
        }
        return item.asHexString();
    }
}

