/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.kyori.adventure.text.minimessage;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.examination.Examinable;
import io.github.pronze.lib.kyori.examination.ExaminableProperty;
import io.github.pronze.lib.kyori.examination.string.StringExaminer;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface Template
extends Examinable {
    public static @NonNull Template of(@NonNull String key, @NonNull String value) {
        return new StringTemplate(key, value);
    }

    public static @NonNull Template of(@NonNull String key, @NonNull Component value) {
        return new ComponentTemplate(key, value);
    }

    public static class ComponentTemplate
    implements Template {
        private final String key;
        private final Component value;

        public ComponentTemplate(@NonNull String key, @NonNull Component value) {
            this.key = key;
            this.value = value;
        }

        public @NonNull String key() {
            return this.key;
        }

        public @NonNull Component value() {
            return this.value;
        }

        public final String toString() {
            return this.examine(StringExaminer.simpleEscaping());
        }

        @Override
        public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
            return Stream.of(ExaminableProperty.of("key", this.key), ExaminableProperty.of("value", this.value));
        }
    }

    public static class StringTemplate
    implements Template {
        private final String key;
        private final String value;

        StringTemplate(@NonNull String key, @NonNull String value) {
            this.key = key;
            this.value = value;
        }

        public @NonNull String key() {
            return this.key;
        }

        public @NonNull String value() {
            return this.value;
        }

        public final String toString() {
            return this.examine(StringExaminer.simpleEscaping());
        }

        @Override
        public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
            return Stream.of(ExaminableProperty.of("key", this.key), ExaminableProperty.of("value", this.value));
        }
    }
}

