/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.kyori.adventure.text.minimessage.parser;

import io.github.pronze.lib.kyori.adventure.text.minimessage.Context;
import io.github.pronze.lib.kyori.adventure.text.minimessage.parser.ParsingException;
import io.github.pronze.lib.kyori.adventure.text.minimessage.parser.Token;
import io.github.pronze.lib.kyori.adventure.text.minimessage.parser.TokenType;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class MiniMessageLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    public static final int TAG = 2;
    public static final int TAG_DUMMY = 4;
    public static final int PARAM = 6;
    public static final int SINGLE_QUOTED = 8;
    public static final int DOUBLE_QUOTED = 10;
    public static final int STRING = 12;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6};
    private static final int[] ZZ_CMAP_TOP = MiniMessageLexer.zzUnpackcmap_top();
    private static final String ZZ_CMAP_TOP_PACKED_0 = "\u0001\u0000\u10ff\u0100";
    private static final int[] ZZ_CMAP_BLOCKS = MiniMessageLexer.zzUnpackcmap_blocks();
    private static final String ZZ_CMAP_BLOCKS_PACKED_0 = "\t\u0000\u0002\u0001\u0002\u0000\u0001\u0001\u0012\u0000\u0001\u0002\u0001\u0000\u0001\u0003\u0001\u0004\u0003\u0000\u0001\u0005\u0005\u0000\u0002\u0004\u0001\u0006\n\u0004\u0001\u0007\u0001\u0000\u0001\b\u0001\u0000\u0001\t\u0002\u0000\r\u0004\u0001\n\f\u0004\u0001\u0000\u0001\u000b\u0002\u0000\u0001\u0004\u0001\u0000\r\u0004\u0001\n\f\u0004\u0185\u0000";
    private static final int[] ZZ_ACTION = MiniMessageLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0007\u0000\u0001\u0001\u0001\u0002\u0001\u0001\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0004\u0001\u0007\u0001\u0002\u0001\b\u0001\t\u0001\n\u0001\u000b\u0001\f\u0001\r\u0001\u0004\u0001\u000e\u0001\u0004\u0001\u000f\u0001\u0004\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0017";
    private static final int[] ZZ_ROWMAP = MiniMessageLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\f\u0000\u0018\u0000$\u00000\u0000<\u0000H\u0000T\u0000`\u0000l\u0000T\u0000x\u0000T\u0000T\u0000T\u0000\u0084\u0000T\u0000T\u0000T\u0000T\u0000T\u0000T\u0000T\u0000\u0090\u0000T\u0000\u009c\u0000\u00a8\u0000\u00b4\u0000T\u0000\u00c0\u0000T\u0000T\u0000\u00cc\u0000T\u0000T\u0000T";
    private static final int[] ZZ_TRANS = MiniMessageLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\b\b\u0001\t\u0002\b\u0001\n\u0002\u000b\u0001\f\u0001\u000b\u0001\f\u0001\u000b\u0001\f\u0001\r\u0001\u000b\u0001\u000e\u0001\f\u0001\u000b\u0001\u000f\u0002\u0010\u0004\u000f\u0001\r\u0001\u0011\u0001\u000e\u0002\u000f\u0002\u0012\u0001\f\u0001\u0013\u0001\f\u0001\u0014\u0001\f\u0001\u0015\u0001\u0012\u0001\u0016\u0001\f\u0001\u0012\u0005\u000f\u0001\u0017\u0005\u000f\u0001\u0018\u0003\u000f\u0001\u0019\u0007\u000f\u0001\u001a\b\u000f\u0001\u001b\u0001\u0016\u0001\u000f\u0001\u001c\u0012\u0000\u0001\u001d\r\u0000\u0001\u001e\u0005\u0000\u0001\f\u0001\u0000\u0001\f\u0001\u0000\u0001\f\u0003\u0000\u0001\f\u0002\u0000\u0002\u0010\u000e\u0000\u0001\u001f\t\u0000\u0001\u001f\u000e\u0000\u0001 \r\u0000\u0001!\u0001\u0000\u0001\"\u0007\u0000\u0001#\u000b\u0000\u0001$\u0005\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = MiniMessageLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0007\u0000\u0001\t\u0002\u0001\u0001\t\u0001\u0001\u0003\t\u0001\u0001\u0007\t\u0001\u0001\u0001\t\u0003\u0001\u0001\t\u0001\u0001\u0002\t\u0001\u0001\u0003\t";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private boolean zzAtEOF;
    private int zzFinalHighSurrogate = 0;
    private int yyline;
    private int yycolumn;
    private long yychar;
    private boolean zzAtBOL = true;
    private boolean zzEOFDone;
    private final StringBuffer string = new StringBuffer();
    private final List<Token> tokens = new ArrayList<Token>();
    private String input = "error";
    private Context context;

    private static int[] zzUnpackcmap_top() {
        int[] result = new int[4352];
        int offset = 0;
        offset = MiniMessageLexer.zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackcmap_top(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackcmap_blocks() {
        int[] result = new int[512];
        int offset = 0;
        offset = MiniMessageLexer.zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackcmap_blocks(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAction() {
        int[] result = new int[36];
        int offset = 0;
        offset = MiniMessageLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[36];
        int offset = 0;
        offset = MiniMessageLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[216];
        int offset = 0;
        offset = MiniMessageLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[36];
        int offset = 0;
        offset = MiniMessageLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public MiniMessageLexer(String input, Context context) {
        this(new StringReader(input));
        this.input = input;
        this.context = context;
    }

    public void clean() {
        this.tokens.removeIf(t -> t.value().length() == 0);
    }

    public List<Token> getTokens() {
        return this.tokens;
    }

    public String getString() {
        String s = this.string.toString();
        this.string.setLength(0);
        return s;
    }

    public List<Token> scan() throws IOException {
        try {
            while (this.zzScan() != null) {
            }
        }
        catch (ParsingException ex) {
            StringBuilder msg = new StringBuilder();
            msg.append(ex.getMessage()).append("\n");
            msg.append(this.input).append("\n");
            msg.append(this.padding(ex.column())).append("^--- HERE");
            ex.message(msg.toString());
            throw ex;
        }
        this.tokens.removeIf(t -> t.value().length() == 0);
        return this.tokens;
    }

    private String padding(int length) {
        if (length > 0) {
            char[] array = new char[length];
            Arrays.fill(array, ' ');
            return new String(array);
        }
        return "";
    }

    public void checkStrict(ParsingException ex) {
        if (this.context.isStrict()) {
            throw ex;
        }
        this.string.append(this.yytext());
    }

    public MiniMessageLexer(Reader in) {
        this.zzReader = in;
    }

    private static int zzCMap(int input) {
        int offset = input & 0xFF;
        return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
    }

    private boolean zzRefill() throws IOException {
        int requested;
        int numRead;
        if (this.zzStartRead > 0) {
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length - this.zzFinalHighSurrogate) {
            char[] newBuffer = new char[this.zzBuffer.length * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, requested = this.zzBuffer.length - this.zzEndRead)) == 0) {
            throw new IOException("Reader returned 0 characters. See JFlex examples/zero-reader for a workaround.");
        }
        if (numRead > 0) {
            this.zzEndRead += numRead;
            if (Character.isHighSurrogate(this.zzBuffer[this.zzEndRead - 1])) {
                if (numRead == requested) {
                    --this.zzEndRead;
                    this.zzFinalHighSurrogate = 1;
                } else {
                    int c = this.zzReader.read();
                    if (c == -1) {
                        return true;
                    }
                    this.zzBuffer[this.zzEndRead++] = (char)c;
                }
            }
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzEOFDone = false;
        this.yyResetPosition();
        this.zzLexicalState = 0;
        if (this.zzBuffer.length > 16384) {
            this.zzBuffer = new char[16384];
        }
    }

    private final void yyResetPosition() {
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzCurrentPos = 0;
        this.zzMarkedPos = 0;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzFinalHighSurrogate = 0;
        this.yyline = 0;
        this.yycolumn = 0;
        this.yychar = 0L;
    }

    public final boolean yyatEOF() {
        return this.zzAtEOF;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int position) {
        return this.zzBuffer[this.zzStartRead + position];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private static void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            MiniMessageLexer.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public Token zzScan() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block57: while (true) {
            int zzInput;
            boolean eof;
            int zzCurrentPosL;
            int zzCharCount;
            int zzMarkedPosL = this.zzMarkedPos;
            boolean zzR = false;
            block58: for (zzCurrentPosL = this.zzStartRead; zzCurrentPosL < zzMarkedPosL; zzCurrentPosL += zzCharCount) {
                int zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
                zzCharCount = Character.charCount(zzCh);
                switch (zzCh) {
                    case 11: 
                    case 12: 
                    case 133: 
                    case 8232: 
                    case 8233: {
                        ++this.yyline;
                        this.yycolumn = 0;
                        zzR = false;
                        continue block58;
                    }
                    case 13: {
                        ++this.yyline;
                        this.yycolumn = 0;
                        zzR = true;
                        continue block58;
                    }
                    case 10: {
                        if (zzR) {
                            zzR = false;
                            continue block58;
                        }
                        ++this.yyline;
                        this.yycolumn = 0;
                        continue block58;
                    }
                    default: {
                        zzR = false;
                        this.yycolumn += zzCharCount;
                    }
                }
            }
            if (zzR) {
                boolean zzPeek;
                if (zzMarkedPosL < zzEndReadL) {
                    zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                } else if (this.zzAtEOF) {
                    zzPeek = false;
                } else {
                    eof = this.zzRefill();
                    zzEndReadL = this.zzEndRead;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    if (eof) {
                        zzPeek = false;
                    } else {
                        boolean bl = zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                    }
                }
                if (zzPeek) {
                    --this.yyline;
                }
            }
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
                    zzCurrentPosL += Character.charCount(zzInput);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
                    zzCurrentPosL += Character.charCount(zzInput);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + MiniMessageLexer.zzCMap(zzInput)];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                switch (this.zzLexicalState) {
                    case 12: {
                        this.yybegin(0);
                        this.tokens.add(new Token(this.getString()));
                    }
                    case 37: {
                        continue block57;
                    }
                }
                return null;
            }
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    this.string.setLength(0);
                    this.string.append(this.yytext());
                    this.yybegin(12);
                }
                case 24: {
                    continue block57;
                }
                case 2: {
                    this.yybegin(2);
                    this.string.setLength(0);
                    this.tokens.add(new Token(TokenType.OPEN_TAG_START));
                }
                case 25: {
                    continue block57;
                }
                case 3: {
                    this.checkStrict(new ParsingException("Illegal character '" + this.yytext() + "'. Only alphanumeric + ._-#/ are allowed as token names", this.yycolumn));
                }
                case 26: {
                    continue block57;
                }
                case 4: {
                    this.string.append(this.yytext());
                }
                case 27: {
                    continue block57;
                }
                case 5: {
                    this.yybegin(6);
                    this.tokens.add(new Token(TokenType.NAME, this.getString()));
                    this.tokens.add(new Token(TokenType.PARAM_SEPARATOR));
                }
                case 28: {
                    continue block57;
                }
                case 6: {
                    this.yybegin(0);
                    this.tokens.add(new Token(TokenType.NAME, this.getString()));
                    this.tokens.add(new Token(TokenType.TAG_END));
                }
                case 29: {
                    continue block57;
                }
                case 7: {
                    this.yybegin(0);
                    this.tokens.add(new Token(this.getString()));
                }
                case 30: {
                    continue block57;
                }
                case 8: {
                    this.checkStrict(new ParsingException("Illegal character '" + this.yytext() + "'. Only alphanumeric + ._-#/ and spaces are allowed as params", this.yycolumn));
                }
                case 31: {
                    continue block57;
                }
                case 9: {
                    this.yybegin(10);
                    this.tokens.add(new Token(TokenType.DOUBLE_QUOTE_START));
                }
                case 32: {
                    continue block57;
                }
                case 10: {
                    this.yybegin(8);
                    this.tokens.add(new Token(TokenType.SINGLE_QUOTE_START));
                }
                case 33: {
                    continue block57;
                }
                case 11: {
                    this.tokens.add(new Token(this.getString()));
                    this.tokens.add(new Token(TokenType.PARAM_SEPARATOR));
                }
                case 34: {
                    continue block57;
                }
                case 12: {
                    this.yybegin(0);
                    this.tokens.add(new Token(this.getString()));
                    this.tokens.add(new Token(TokenType.TAG_END));
                }
                case 35: {
                    continue block57;
                }
                case 13: {
                    this.yybegin(6);
                    this.tokens.add(new Token(this.getString()));
                    this.tokens.add(new Token(TokenType.SINGLE_QUOTE_END));
                }
                case 36: {
                    continue block57;
                }
                case 14: {
                    this.yybegin(6);
                    this.tokens.add(new Token(this.getString()));
                    this.tokens.add(new Token(TokenType.DOUBLE_QUOTE_END));
                }
                case 37: {
                    continue block57;
                }
                case 15: {
                    this.yybegin(2);
                    this.tokens.add(new Token(this.getString()));
                    this.tokens.add(new Token(TokenType.OPEN_TAG_START));
                }
                case 38: {
                    continue block57;
                }
                case 16: {
                    this.yybegin(2);
                    this.string.setLength(0);
                    this.tokens.add(new Token(TokenType.CLOSE_TAG_START));
                }
                case 39: {
                    continue block57;
                }
                case 17: {
                    this.yybegin(4);
                    this.string.setLength(0);
                    this.tokens.add(new Token(TokenType.ESCAPED_OPEN_TAG_START));
                }
                case 40: {
                    continue block57;
                }
                case 18: {
                    this.string.append(this.yytext().substring(1));
                }
                case 41: {
                    continue block57;
                }
                case 19: {
                    this.yybegin(2);
                    this.tokens.add(new Token(this.getString()));
                    this.tokens.add(new Token(TokenType.CLOSE_TAG_START));
                }
                case 42: {
                    continue block57;
                }
                case 20: {
                    this.yybegin(4);
                    this.tokens.add(new Token(this.getString()));
                    this.tokens.add(new Token(TokenType.ESCAPED_OPEN_TAG_START));
                }
                case 43: {
                    continue block57;
                }
                case 21: {
                    this.string.append('\n');
                }
                case 44: {
                    continue block57;
                }
                case 22: {
                    this.yybegin(4);
                    this.string.setLength(0);
                    this.tokens.add(new Token(TokenType.ESCAPED_CLOSE_TAG_START));
                }
                case 45: {
                    continue block57;
                }
                case 23: {
                    this.yybegin(4);
                    this.tokens.add(new Token(this.getString()));
                    this.tokens.add(new Token(TokenType.ESCAPED_CLOSE_TAG_START));
                }
                case 46: {
                    continue block57;
                }
            }
            MiniMessageLexer.zzScanError(1);
        }
    }
}

