/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.kyori.adventure.text.minimessage.transformation.inbuild;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.TextComponent;
import io.github.pronze.lib.kyori.adventure.text.format.NamedTextColor;
import io.github.pronze.lib.kyori.adventure.text.format.TextColor;
import io.github.pronze.lib.kyori.adventure.text.minimessage.parser.ParsingException;
import io.github.pronze.lib.kyori.adventure.text.minimessage.parser.Token;
import io.github.pronze.lib.kyori.adventure.text.minimessage.parser.TokenType;
import io.github.pronze.lib.kyori.adventure.text.minimessage.transformation.Inserting;
import io.github.pronze.lib.kyori.adventure.text.minimessage.transformation.OneTimeTransformation;
import io.github.pronze.lib.kyori.adventure.text.minimessage.transformation.Transformation;
import io.github.pronze.lib.kyori.adventure.text.minimessage.transformation.TransformationParser;
import io.github.pronze.lib.kyori.examination.ExaminableProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class GradientTransformation
extends OneTimeTransformation
implements Inserting {
    private int index = 0;
    private int colorIndex = 0;
    private float factorStep = 0.0f;
    private TextColor[] colors;
    private float phase = 0.0f;
    private boolean negativePhase = false;

    public static boolean canParse(String name) {
        return name.equalsIgnoreCase("gradient");
    }

    private GradientTransformation() {
    }

    @Override
    public void load(String name, List<Token> args) {
        super.load(name, args);
        if (!args.isEmpty()) {
            ArrayList<TextColor> textColors = new ArrayList<TextColor>();
            for (int i = 0; i < args.size(); ++i) {
                TextColor parsedColor;
                Token arg = args.get(i);
                if (arg.type() != TokenType.STRING) continue;
                if (i == args.size() - 1) {
                    try {
                        this.phase = Float.parseFloat(arg.value());
                        if (this.phase < -1.0f || this.phase > 1.0f) {
                            throw new ParsingException(String.format("Gradient phase is out of range (%s). Must be in the range [-1.0f, 1.0f] (inclusive).", Float.valueOf(this.phase)), -1);
                        }
                        if (!(this.phase < 0.0f)) break;
                        this.negativePhase = true;
                        this.phase = 1.0f + this.phase;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if ((parsedColor = arg.value().charAt(0) == '#' ? TextColor.fromHexString(arg.value()) : (TextColor)NamedTextColor.NAMES.value(arg.value().toLowerCase(Locale.ROOT))) == null) {
                    throw new ParsingException(String.format("Unable to parse a color from '%s'. Please use NamedTextColors or Hex colors.", arg.value()), -1);
                }
                textColors.add(parsedColor);
            }
            if (textColors.size() < 2) {
                throw new ParsingException("Invalid gradient, not enough colors. Gradients must have at least two colors.", -1);
            }
            this.colors = textColors.toArray(new TextColor[0]);
            if (this.negativePhase) {
                Collections.reverse(Arrays.asList(this.colors));
            }
        } else {
            this.colors = new TextColor[]{TextColor.fromHexString("#ffffff"), TextColor.fromHexString("#000000")};
        }
    }

    @Override
    public Component applyOneTime(@NonNull Component current, @NonNull TextComponent.Builder parent, @NonNull Deque<Transformation> transformations) {
        if (current instanceof TextComponent) {
            TextComponent textComponent = (TextComponent)current;
            String content = textComponent.content();
            int size = content.length();
            int sectorLength = size / (this.colors.length - 1);
            this.factorStep = 1.0f / (float)(sectorLength + this.index);
            this.phase *= (float)sectorLength;
            this.index = 0;
            char[] holder = new char[2];
            PrimitiveIterator.OfInt it = content.codePoints().iterator();
            while (it.hasNext()) {
                int charSize = Character.toChars(it.nextInt(), holder, 0);
                Component comp = Component.text(new String(holder, 0, charSize));
                comp = this.merge(comp, current);
                comp = comp.color(this.color());
                parent.append(comp);
            }
            return null;
        }
        throw new ParsingException("Expected TextComponent, got: " + current.getClass().toString(), -1);
    }

    private TextColor color() {
        if (this.factorStep * (float)this.index > 1.0f) {
            ++this.colorIndex;
            this.index = 0;
        }
        int n = this.index++;
        float factor = this.factorStep * ((float)n + this.phase);
        if (factor > 1.0f) {
            factor = 1.0f - (factor - 1.0f);
        }
        if (this.negativePhase && this.colors.length % 2 != 0) {
            return this.interpolate(this.colors[this.colorIndex + 1], this.colors[this.colorIndex], factor);
        }
        return this.interpolate(this.colors[this.colorIndex], this.colors[this.colorIndex + 1], factor);
    }

    private TextColor interpolate(TextColor color1, TextColor color2, float factor) {
        return TextColor.color(Math.round((float)color1.red() + factor * (float)(color2.red() - color1.red())), Math.round((float)color1.green() + factor * (float)(color2.green() - color1.green())), Math.round((float)color1.blue() + factor * (float)(color2.blue() - color1.blue())));
    }

    @Override
    public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("phase", this.phase), ExaminableProperty.of("colors", this.colors));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GradientTransformation that = (GradientTransformation)other;
        return this.index == that.index && this.colorIndex == that.colorIndex && Float.compare(that.factorStep, this.factorStep) == 0 && this.phase == that.phase && Arrays.equals(this.colors, that.colors);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(this.index, this.colorIndex, Float.valueOf(this.factorStep), Float.valueOf(this.phase));
        result = 31 * result + Arrays.hashCode(this.colors);
        return result;
    }

    public static class Parser
    implements TransformationParser<GradientTransformation> {
        @Override
        public GradientTransformation parse() {
            return new GradientTransformation();
        }
    }
}

