/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.kyori.adventure.text.minimessage.transformation.inbuild;

import io.github.pronze.lib.kyori.adventure.key.InvalidKeyException;
import io.github.pronze.lib.kyori.adventure.key.Key;
import io.github.pronze.lib.kyori.adventure.nbt.api.BinaryTagHolder;
import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.TextComponent;
import io.github.pronze.lib.kyori.adventure.text.event.HoverEvent;
import io.github.pronze.lib.kyori.adventure.text.minimessage.parser.ParsingException;
import io.github.pronze.lib.kyori.adventure.text.minimessage.parser.Token;
import io.github.pronze.lib.kyori.adventure.text.minimessage.parser.TokenType;
import io.github.pronze.lib.kyori.adventure.text.minimessage.transformation.Transformation;
import io.github.pronze.lib.kyori.adventure.text.minimessage.transformation.TransformationParser;
import io.github.pronze.lib.kyori.examination.ExaminableProperty;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class HoverTransformation
extends Transformation {
    private static final Pattern REALLY_DUM_SPLIT_PATTERN = Pattern.compile("(?s):(?=(?:((?<!\\\\)[\"'])(?:(?!(?<!\\\\)\\1).)*(?<!\\\\)\\1|\\\\.|[^\"'])*$)");
    private HoverEvent.Action<Object> action;
    private Object value;

    public static boolean canParse(String name) {
        return name.equalsIgnoreCase("hover");
    }

    private HoverTransformation() {
    }

    @Override
    public void load(String name, List<Token> args) {
        super.load(name, args);
        if (args.size() < 3 || args.get(0).type() != TokenType.STRING) {
            throw new ParsingException("Doesn't know how to turn " + args + " into a hover event", -1);
        }
        String string = Token.asValueString(args.subList(2, args.size()));
        this.action = HoverEvent.Action.NAMES.value(args.get(0).value());
        if (this.action == HoverEvent.Action.SHOW_TEXT) {
            this.value = this.context.parse(HoverTransformation.stripOuterQuotes(string));
        } else if (this.action == HoverEvent.Action.SHOW_ITEM) {
            this.value = this.parseShowItem(string);
        } else if (this.action == HoverEvent.Action.SHOW_ENTITY) {
            this.value = this.parseShowEntity(string);
        } else {
            throw new ParsingException("Don't know how to turn '" + args + "' into a hover event", -1);
        }
    }

    private static @NonNull String stripOuterQuotes(@NonNull String string) {
        if (string.length() != 1 && HoverTransformation.startsAndEndsWithQuotes(string)) {
            return string.substring(1).substring(0, string.length() - 2);
        }
        return string;
    }

    private static boolean startsAndEndsWithQuotes(@NonNull String string) {
        return string.startsWith("'") && string.endsWith("'") || string.startsWith("\"") && string.endsWith("\"");
    }

    private @NonNull HoverEvent.ShowItem parseShowItem(@NonNull String value) {
        try {
            String[] args = REALLY_DUM_SPLIT_PATTERN.split(value);
            if (args.length == 0) {
                throw new RuntimeException("Show item hover needs at least item id!");
            }
            Key key = Key.key(HoverTransformation.stripOuterQuotes(args[0]));
            int count = args.length >= 2 ? Integer.parseInt(HoverTransformation.stripOuterQuotes(args[1])) : 1;
            if (args.length == 3) {
                return HoverEvent.ShowItem.of(key, count, BinaryTagHolder.of(HoverTransformation.stripOuterQuotes(args[2])));
            }
            return HoverEvent.ShowItem.of(key, count);
        }
        catch (InvalidKeyException | NumberFormatException ex) {
            throw new RuntimeException(String.format("Exception parsing show_item hover '%s'.", value), ex);
        }
    }

    private @NonNull HoverEvent.ShowEntity parseShowEntity(@NonNull String value) {
        try {
            String[] args = REALLY_DUM_SPLIT_PATTERN.split(value);
            if (args.length <= 1) {
                throw new RuntimeException("Show entity hover needs at least type and uuid!");
            }
            Key key = Key.key(HoverTransformation.stripOuterQuotes(args[0]));
            UUID id = UUID.fromString(HoverTransformation.stripOuterQuotes(args[1]));
            if (args.length == 3) {
                Component name = this.context.parse(HoverTransformation.stripOuterQuotes(args[2]));
                return HoverEvent.ShowEntity.of(key, id, name);
            }
            return HoverEvent.ShowEntity.of(key, id);
        }
        catch (InvalidKeyException | IllegalArgumentException ex) {
            throw new RuntimeException(String.format("Exception parsing show_entity hover '%s'.", value), ex);
        }
    }

    @Override
    public Component apply(Component component, TextComponent.Builder parent) {
        return component.hoverEvent(HoverEvent.hoverEvent(this.action, this.value));
    }

    @Override
    public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("action", this.action), ExaminableProperty.of("value", this.value));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        HoverTransformation that = (HoverTransformation)other;
        return Objects.equals(this.action, that.action) && Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.action, this.value);
    }

    public static class Parser
    implements TransformationParser<HoverTransformation> {
        @Override
        public HoverTransformation parse() {
            return new HoverTransformation();
        }
    }
}

