/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.kyori.adventure.text.minimessage.transformation.inbuild;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.minimessage.parser.ParsingException;
import io.github.pronze.lib.kyori.adventure.text.minimessage.parser.Token;
import io.github.pronze.lib.kyori.adventure.text.minimessage.transformation.Inserting;
import io.github.pronze.lib.kyori.adventure.text.minimessage.transformation.OneTimeTransformation;
import io.github.pronze.lib.kyori.adventure.text.minimessage.transformation.Transformation;
import io.github.pronze.lib.kyori.adventure.text.minimessage.transformation.TransformationParser;
import io.github.pronze.lib.kyori.examination.ExaminableProperty;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class KeybindTransformation
extends OneTimeTransformation
implements Inserting {
    private String keybind;

    public static boolean canParse(String name) {
        return name.equalsIgnoreCase("key");
    }

    private KeybindTransformation() {
    }

    @Override
    public void load(String name, List<Token> args) {
        super.load(name, args);
        if (!Token.oneString(args)) {
            throw new ParsingException("Doesn't know how to turn token with name '" + name + "' and arguments " + args + " into a keybind component", -1);
        }
        this.keybind = args.get(0).value();
    }

    @Override
    public Component applyOneTime(@NonNull Component current,  @NonNull TextComponent.Builder parent, @NonNull Deque<Transformation> transformations) {
        parent.append(this.merge(Component.keybind(this.keybind), current));
        return current;
    }

    @Override
    public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("keybind", this.keybind));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        KeybindTransformation that = (KeybindTransformation)other;
        return Objects.equals(this.keybind, that.keybind);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.keybind);
    }

    public static class Parser
    implements TransformationParser<KeybindTransformation> {
        @Override
        public KeybindTransformation parse() {
            return new KeybindTransformation();
        }
    }
}

