/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.kyori.adventure.text.minimessage.transformation.inbuild;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.TextComponent;
import io.github.pronze.lib.kyori.adventure.text.format.TextColor;
import io.github.pronze.lib.kyori.adventure.text.minimessage.parser.ParsingException;
import io.github.pronze.lib.kyori.adventure.text.minimessage.parser.Token;
import io.github.pronze.lib.kyori.adventure.text.minimessage.transformation.Inserting;
import io.github.pronze.lib.kyori.adventure.text.minimessage.transformation.OneTimeTransformation;
import io.github.pronze.lib.kyori.adventure.text.minimessage.transformation.Transformation;
import io.github.pronze.lib.kyori.adventure.text.minimessage.transformation.TransformationParser;
import io.github.pronze.lib.kyori.examination.ExaminableProperty;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class RainbowTransformation
extends OneTimeTransformation
implements Inserting {
    private int colorIndex = 0;
    private float center = 128.0f;
    private float width = 127.0f;
    private double frequency = 1.0;
    private int phase;

    public static boolean canParse(String name) {
        return name.equalsIgnoreCase("rainbow");
    }

    private RainbowTransformation() {
    }

    @Override
    public void load(String name, List<Token> args) {
        super.load(name, args);
        if (Token.oneString(args)) {
            try {
                this.phase = Integer.parseInt(args.get(0).value());
            }
            catch (NumberFormatException ex) {
                throw new ParsingException("Expected phase, got " + args.get(0).value(), -1);
            }
        }
    }

    @Override
    public Component applyOneTime(@NonNull Component current, @NonNull TextComponent.Builder parent, @NonNull Deque<Transformation> transformations) {
        if (current instanceof TextComponent) {
            TextComponent textComponent = (TextComponent)current;
            String content = textComponent.content();
            this.center = 128.0f;
            this.width = 127.0f;
            this.frequency = Math.PI * 2 / (double)content.length();
            char[] holder = new char[2];
            PrimitiveIterator.OfInt it = content.codePoints().iterator();
            while (it.hasNext()) {
                int charSize = Character.toChars(it.nextInt(), holder, 0);
                Component comp = Component.text(new String(holder, 0, charSize));
                comp = this.merge(comp, current);
                comp = comp.color(this.color(this.phase));
                parent.append(comp);
            }
            return null;
        }
        throw new ParsingException("Expected Text Comp", -1);
    }

    private TextColor color(float phase) {
        int index = this.colorIndex++;
        int red = (int)(Math.sin(this.frequency * (double)index + 2.0 + (double)phase) * (double)this.width + (double)this.center);
        int green = (int)(Math.sin(this.frequency * (double)index + 0.0 + (double)phase) * (double)this.width + (double)this.center);
        int blue = (int)(Math.sin(this.frequency * (double)index + 4.0 + (double)phase) * (double)this.width + (double)this.center);
        return TextColor.color(red, green, blue);
    }

    @Override
    public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("phase", this.phase));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RainbowTransformation that = (RainbowTransformation)other;
        return this.colorIndex == that.colorIndex && Float.compare(that.center, this.center) == 0 && Float.compare(that.width, this.width) == 0 && Double.compare(that.frequency, this.frequency) == 0 && this.phase == that.phase;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.colorIndex, Float.valueOf(this.center), Float.valueOf(this.width), this.frequency, this.phase);
    }

    public static class Parser
    implements TransformationParser<RainbowTransformation> {
        @Override
        public RainbowTransformation parse() {
            return new RainbowTransformation();
        }
    }
}

