/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.pronzelib.scoreboards;

import io.github.pronze.lib.pronzelib.scoreboards.ScoreboardManager;
import io.github.pronze.lib.pronzelib.scoreboards.animations.ScoreboardAnimator;
import io.github.pronze.lib.pronzelib.scoreboards.api.PlaceholderFunction;
import io.github.pronze.lib.pronzelib.scoreboards.api.UpdateCallback;
import io.github.pronze.lib.pronzelib.scoreboards.builder.ScoreboardBuilder;
import io.github.pronze.lib.pronzelib.scoreboards.holder.ScoreboardHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class Scoreboard {
    private final ScoreboardHolder holder;
    protected BukkitTask animationTask;
    protected BukkitTask updateTask;
    private long ANIMATION_TASK_INTERVAL = 2L;
    private long UPDATE_TASK_INTERVAL = 20L;
    private boolean occupyMaxHeight = false;
    private boolean occupyMaxWidth = false;
    private UpdateCallback callback;
    private List<String> animatedTitle;
    private boolean updateTaskRunning = false;
    private boolean animationTaskRunning = false;

    public Scoreboard(Player player) {
        if (ScoreboardManager.getPluginInstance() == null) {
            throw new NullPointerException("Plugin instance not set! call ScoreboardManager.install() first");
        }
        this.holder = new ScoreboardHolder(player);
        this.startUpdateTask();
        ScoreboardManager.getInstance().addToCache(this);
    }

    public static ScoreboardBuilder builder() {
        return new ScoreboardBuilder();
    }

    public void setLines(List<String> lines) {
        if (lines == null || lines.isEmpty()) {
            return;
        }
        if (lines.equals(this.holder.getLines().values())) {
            return;
        }
        lines = this.resizeContent(lines);
        Collections.reverse(lines);
        int i = 0;
        for (String line : lines) {
            this.holder.setLine(i, line);
            ++i;
        }
    }

    public void setVisibility(boolean visible) {
        this.holder.setVisible(visible);
        this.refresh();
    }

    public void refresh() {
        this.holder.registerObjective(this.holder.getObjectiveName());
        this.holder.setTitle(this.holder.getDisplayName());
        TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>((SortedMap<Integer, String>)this.holder.getLines());
        ScoreboardHolder holder = this.holder;
        Objects.requireNonNull(holder);
        treeMap.forEach((k, v) -> holder.setLine((int)k, (String)v));
    }

    public void setTitle(String title, boolean animate) {
        Objects.requireNonNull(title, "Title cannot be null");
        if (animate) {
            this.startAnimationTask(ScoreboardAnimator.getAnimatedTitle(title));
        } else {
            this.holder.setTitle(title);
        }
    }

    public void setAnimatedTitle(List<String> animatedTitle) {
        if (animatedTitle == null || animatedTitle.isEmpty()) {
            throw new IllegalArgumentException("Animated title cannot be null or empty");
        }
        if (animatedTitle.size() == 1) {
            this.setTitle(animatedTitle.get(0), false);
            return;
        }
        this.startAnimationTask(animatedTitle);
        this.animatedTitle = animatedTitle;
    }

    public void cancelAnimationTask() {
        if (this.animationTask != null) {
            if (Bukkit.getScheduler().isQueued(this.animationTask.getTaskId()) || Bukkit.getScheduler().isCurrentlyRunning(this.animationTask.getTaskId()) || this.animationTaskRunning) {
                this.animationTask.cancel();
                this.animationTaskRunning = false;
            }
            this.animationTask = null;
        }
    }

    private void cancelUpdateTask() {
        if (this.updateTask != null) {
            if (Bukkit.getScheduler().isQueued(this.updateTask.getTaskId()) || Bukkit.getScheduler().isCurrentlyRunning(this.updateTask.getTaskId()) || this.updateTaskRunning) {
                this.updateTask.cancel();
            }
            this.updateTask = null;
        }
    }

    public String makeUnique(String toUnique, List<String> from) {
        if (toUnique == null) {
            toUnique = " ";
        }
        StringBuilder stringBuilder = new StringBuilder(toUnique);
        while (from.contains(stringBuilder.toString()) || this.occupyMaxWidth && !from.contains(stringBuilder) && stringBuilder.length() < 40) {
            stringBuilder.append(" ");
        }
        if (stringBuilder.length() > 40) {
            return stringBuilder.substring(0, 40);
        }
        return stringBuilder.toString();
    }

    public List<String> resizeContent(List<String> lines) {
        ArrayList<String> newList = new ArrayList<String>();
        lines.forEach(line -> newList.add(this.makeUnique((String)line, (List<String>)newList)));
        if (newList.size() > 15) {
            return newList.subList(0, 15);
        }
        if (this.occupyMaxHeight) {
            while (newList.size() < 16) {
                newList.add(this.makeUnique(" ", newList));
            }
        }
        return newList;
    }

    public void destroy() {
        this.holder.setDestroyed(true);
        this.cancelTasks();
        this.holder.destroy();
        ScoreboardManager.getInstance().removeFromCache(this.holder.getPlayer().getUniqueId());
    }

    public void setPlaceholderHook(PlaceholderFunction papiFunction) {
        this.holder.setPapiFunction(papiFunction);
    }

    public void addInternalPlaceholder(String placeholder, Object value) {
        this.holder.getPersistentPlaceholders().put(placeholder, value.toString());
    }

    public void setUpdateTaskInterval(long interval) {
        this.UPDATE_TASK_INTERVAL = interval;
        this.startUpdateTask();
    }

    public void setAnimationTaskInterval(long interval) {
        this.ANIMATION_TASK_INTERVAL = interval;
        this.startAnimationTask(this.animatedTitle);
    }

    public void setCallback(UpdateCallback callback) {
        this.callback = callback;
    }

    protected void startAnimationTask(final List<String> animatedTitle) {
        this.cancelAnimationTask();
        if (animatedTitle == null) {
            return;
        }
        this.animationTaskRunning = true;
        this.animationTask = new BukkitRunnable(){
            int pos = 0;

            public void run() {
                if (Scoreboard.this.holder.isDestroyed()) {
                    this.cancel();
                    return;
                }
                if (this.pos >= animatedTitle.size()) {
                    this.pos = 0;
                }
                Scoreboard.this.holder.setTitle((String)animatedTitle.get(this.pos));
                ++this.pos;
            }
        }.runTaskTimer((Plugin)ScoreboardManager.getPluginInstance(), 0L, this.ANIMATION_TASK_INTERVAL);
    }

    protected void startUpdateTask() {
        this.cancelUpdateTask();
        this.updateTaskRunning = true;
        this.updateTask = new BukkitRunnable(){

            public void run() {
                boolean cancelled;
                if (Scoreboard.this.holder.isDestroyed()) {
                    this.cancel();
                    return;
                }
                if (Scoreboard.this.callback != null && (cancelled = Scoreboard.this.callback.onCallback(Scoreboard.this))) {
                    return;
                }
                TreeMap<Integer, String> lines = new TreeMap<Integer, String>((SortedMap<Integer, String>)Scoreboard.this.holder.getLines());
                if (!lines.isEmpty()) {
                    TreeMap<Integer, String> treeMap = lines;
                    ScoreboardHolder holder = Scoreboard.this.holder;
                    Objects.requireNonNull(holder);
                    treeMap.forEach(holder::setLine);
                }
            }
        }.runTaskTimer((Plugin)ScoreboardManager.getPluginInstance(), 0L, this.UPDATE_TASK_INTERVAL);
    }

    protected void cancelTasks() {
        this.cancelAnimationTask();
        this.cancelUpdateTask();
    }

    public ScoreboardHolder getHolder() {
        return this.holder;
    }

    public void setOccupyMaxHeight(boolean occupyMaxHeight) {
        this.occupyMaxHeight = occupyMaxHeight;
    }

    public void setOccupyMaxWidth(boolean occupyMaxWidth) {
        this.occupyMaxWidth = occupyMaxWidth;
    }
}

