/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.pronzelib.scoreboards.holder;

import io.github.pronze.lib.pronzelib.scoreboards.ScoreboardManager;
import io.github.pronze.lib.pronzelib.scoreboards.api.PlaceholderFunction;
import io.github.pronze.lib.pronzelib.scoreboards.data.PlaceholderData;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import lombok.NonNull;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class ScoreboardHolder {
    private final Player player;
    private final Scoreboard bukkitScoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
    private final HashMap<String, Object> persistentPlaceholders = new HashMap();
    private final TreeMap<Integer, String> lines = new TreeMap();
    private boolean isVisible = true;
    private Objective objective;
    private PlaceholderFunction papiFunction;
    private String displayName = "\u00a7c>>>> \u00a7fScoreboard \u00a7c<<<<";
    private String objectiveName = "pronze_lib";
    private boolean destroyed;

    public ScoreboardHolder(Player player) {
        this.player = player;
        this.registerObjective(this.objectiveName);
        this.commit();
    }

    public void commit() {
        if (this.isVisible) {
            Bukkit.getScheduler().runTask((Plugin)ScoreboardManager.getPluginInstance(), () -> this.player.setScoreboard(this.bukkitScoreboard));
        }
    }

    public void destroy() {
        try {
            this.objective.unregister();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.objective = null;
        this.lines.clear();
        this.player.setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
        this.destroyed = true;
    }

    public Optional<Objective> getObjective() {
        return Optional.ofNullable(this.objective);
    }

    public void registerObjective(String objectiveName) {
        if (this.bukkitScoreboard.getObjective(objectiveName) != null) {
            return;
        }
        if (this.objective != null) {
            try {
                this.objective.unregister();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.objective = this.bukkitScoreboard.registerNewObjective(objectiveName, "dummy");
        this.objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        this.objectiveName = objectiveName;
    }

    public void setTitle(String displayName) {
        if (displayName.length() > 32) {
            displayName = displayName.substring(0, 32);
        }
        this.displayName = displayName;
        Optional<Objective> objective = this.getObjective();
        String finalDisplayName = displayName;
        objective.ifPresent(value -> value.setDisplayName(finalDisplayName));
    }

    public void setLine(int pos, String content) {
        if (pos > 15) {
            throw new IllegalArgumentException("Position cannot be greater than 15");
        }
        if (pos < 0) {
            throw new IllegalArgumentException("Position cannot be less than 0");
        }
        Objects.requireNonNull(content, "Content cannot be null!");
        String line = this.lines.get(pos);
        String finalContent = this.setPlaceholders(content);
        if (line != null && line.equalsIgnoreCase(finalContent)) {
            return;
        }
        String anotherString = "";
        Scoreboard bukkitScoreboard = this.bukkitScoreboard;
        Objects.requireNonNull(bukkitScoreboard);
        this.bukkitScoreboard.getEntries().stream().filter(Objects::nonNull).filter(entry -> this.objective.getScore(entry).getScore() == pos && !entry.equalsIgnoreCase("")).forEach(arg_0 -> ((Scoreboard)bukkitScoreboard).resetScores(arg_0));
        Score score = this.objective.getScore(finalContent);
        score.setScore(pos);
        this.lines.put(pos, content);
    }

    public String setPlaceholders(String content) {
        Objects.requireNonNull(content, "Content cannot be null");
        if (this.papiFunction != null) {
            content = this.papiFunction.handleReplace(new PlaceholderData(this.player, this, content));
        }
        for (Map.Entry<String, Object> entry : this.persistentPlaceholders.entrySet()) {
            content = content.replace(entry.getKey(), entry.getValue().toString());
        }
        if (Bukkit.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            content = PlaceholderAPI.setPlaceholders((Player)this.player, (String)content);
        }
        return content;
    }

    public void addTeam(@NonNull String teamName, ChatColor color) {
        if (teamName == null) {
            throw new NullPointerException("teamName is marked non-null but is null");
        }
        Team team = this.getTeamOrRegister(teamName);
        if (!ScoreboardManager.isLegacy()) {
            team.setColor(color);
        } else {
            team.setPrefix(color.toString());
        }
        team.setDisplayName(teamName);
    }

    @NonNull
    public Team getTeamOrRegister(@NonNull String teamName) {
        if (teamName == null) {
            throw new NullPointerException("teamName is marked non-null but is null");
        }
        return this.bukkitScoreboard.getTeam(teamName) == null ? this.bukkitScoreboard.registerNewTeam(teamName) : this.bukkitScoreboard.getTeam(teamName);
    }

    public void removeTeam(@NonNull String teamName) {
        if (teamName == null) {
            throw new NullPointerException("teamName is marked non-null but is null");
        }
        if (!this.hasTeamEntry(teamName)) {
            return;
        }
        Team team = this.bukkitScoreboard.getTeam(teamName);
        if (team == null) {
            return;
        }
        team.unregister();
    }

    public boolean hasTeamEntry(@NonNull String teamName) {
        if (teamName == null) {
            throw new NullPointerException("teamName is marked non-null but is null");
        }
        return this.bukkitScoreboard.getTeams().stream().anyMatch(team -> teamName.equalsIgnoreCase(team.getName()));
    }

    public void addPlayerEntryToTeam(Player player, @NonNull String teamName) {
        if (teamName == null) {
            throw new NullPointerException("teamName is marked non-null but is null");
        }
        Optional<Team> optionalTeam = this.getTeamEntry(teamName);
        if (optionalTeam.isEmpty()) {
            throw new IllegalArgumentException(teamName);
        }
        Team team = optionalTeam.get();
        if (!team.hasEntry(player.getName())) {
            team.addEntry(player.getName());
        }
    }

    public Optional<Team> getTeamEntry(String teamName) {
        return Optional.ofNullable(this.bukkitScoreboard.getTeam(teamName));
    }

    public void removePlayerEntry(Player player) {
        String playerName = player.getName();
        String s = "";
        this.bukkitScoreboard.getTeams().forEach(team -> {
            if (team.hasEntry("")) {
                team.removeEntry("");
            }
        });
    }

    public void setVisible(boolean visibility) {
        this.isVisible = visibility;
        Scoreboard toSet = visibility ? this.bukkitScoreboard : Bukkit.getScoreboardManager().getMainScoreboard();
        this.player.setScoreboard(toSet);
    }

    public void hide() {
        this.setVisible(false);
    }

    public void show() {
        this.setVisible(true);
    }

    public Player getPlayer() {
        return this.player;
    }

    public Scoreboard getBukkitScoreboard() {
        return this.bukkitScoreboard;
    }

    public HashMap<String, Object> getPersistentPlaceholders() {
        return this.persistentPlaceholders;
    }

    public TreeMap<Integer, String> getLines() {
        return this.lines;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public PlaceholderFunction getPapiFunction() {
        return this.papiFunction;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getObjectiveName() {
        return this.objectiveName;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void setObjective(Objective objective) {
        this.objective = objective;
    }

    public void setPapiFunction(PlaceholderFunction papiFunction) {
        this.papiFunction = papiFunction;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setObjectiveName(String objectiveName) {
        this.objectiveName = objectiveName;
    }

    public void setDestroyed(boolean destroyed) {
        this.destroyed = destroyed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScoreboardHolder)) {
            return false;
        }
        ScoreboardHolder other = (ScoreboardHolder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Player this$player = this.getPlayer();
        Player other$player = other.getPlayer();
        if (!(this$player == null ? other$player == null : this$player.equals(other$player))) {
            return false;
        }
        Scoreboard this$bukkitScoreboard = this.getBukkitScoreboard();
        Scoreboard other$bukkitScoreboard = other.getBukkitScoreboard();
        if (!(this$bukkitScoreboard == null ? other$bukkitScoreboard == null : this$bukkitScoreboard.equals(other$bukkitScoreboard))) {
            return false;
        }
        HashMap<String, Object> this$persistentPlaceholders = this.getPersistentPlaceholders();
        HashMap<String, Object> other$persistentPlaceholders = other.getPersistentPlaceholders();
        if (!(this$persistentPlaceholders == null ? other$persistentPlaceholders == null : ((Object)this$persistentPlaceholders).equals(other$persistentPlaceholders))) {
            return false;
        }
        TreeMap<Integer, String> this$lines = this.getLines();
        TreeMap<Integer, String> other$lines = other.getLines();
        if (!(this$lines == null ? other$lines == null : ((Object)this$lines).equals(other$lines))) {
            return false;
        }
        if (this.isVisible() != other.isVisible()) {
            return false;
        }
        Optional<Objective> this$objective = this.getObjective();
        Optional<Objective> other$objective = other.getObjective();
        if (!(this$objective == null ? other$objective == null : ((Object)this$objective).equals(other$objective))) {
            return false;
        }
        PlaceholderFunction this$papiFunction = this.getPapiFunction();
        PlaceholderFunction other$papiFunction = other.getPapiFunction();
        if (!(this$papiFunction == null ? other$papiFunction == null : this$papiFunction.equals(other$papiFunction))) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (!(this$displayName == null ? other$displayName == null : this$displayName.equals(other$displayName))) {
            return false;
        }
        String this$objectiveName = this.getObjectiveName();
        String other$objectiveName = other.getObjectiveName();
        if (this$objectiveName == null ? other$objectiveName == null : this$objectiveName.equals(other$objectiveName)) {
            return this.isDestroyed() == other.isDestroyed();
        }
        return false;
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScoreboardHolder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Player $player = this.getPlayer();
        result = result * 59 + ($player == null ? 43 : $player.hashCode());
        Scoreboard $bukkitScoreboard = this.getBukkitScoreboard();
        result = result * 59 + ($bukkitScoreboard == null ? 43 : $bukkitScoreboard.hashCode());
        HashMap<String, Object> $persistentPlaceholders = this.getPersistentPlaceholders();
        result = result * 59 + ($persistentPlaceholders == null ? 43 : ((Object)$persistentPlaceholders).hashCode());
        TreeMap<Integer, String> $lines = this.getLines();
        result = result * 59 + ($lines == null ? 43 : ((Object)$lines).hashCode());
        result = result * 59 + (this.isVisible() ? 79 : 97);
        Optional<Objective> $objective = this.getObjective();
        result = result * 59 + ($objective == null ? 43 : ((Object)$objective).hashCode());
        PlaceholderFunction $papiFunction = this.getPapiFunction();
        result = result * 59 + ($papiFunction == null ? 43 : $papiFunction.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $objectiveName = this.getObjectiveName();
        result = result * 59 + ($objectiveName == null ? 43 : $objectiveName.hashCode());
        result = result * 59 + (this.isDestroyed() ? 79 : 97);
        return result;
    }

    public String toString() {
        return this.getPlayer() + this.getBukkitScoreboard() + this.getPersistentPlaceholders() + this.getLines() + this.isVisible() + this.getObjective() + this.getPapiFunction() + this.getDisplayName() + this.getObjectiveName() + this.isDestroyed();
    }
}

