/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib;

import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.utils.annotations.AbstractService;
import io.github.pronze.lib.screaminglib.world.WorldHolder;
import io.netty.channel.ChannelFuture;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;

@AbstractService(pattern="^(?<basePackage>.+)\\.(?<className>.+)$", replaceRule="{basePackage}.{platform}.{Platform}{className}")
public abstract class Server {
    private static Server server;

    @ApiStatus.Internal
    public Server() {
        if (server != null) {
            throw new UnsupportedOperationException("Server has been already initialized!");
        }
        server = this;
    }

    public static boolean isServerThread() {
        if (server == null) {
            throw new UnsupportedOperationException("Server has not yet been initialized!");
        }
        return server.isServerThread0();
    }

    public static String getVersion() {
        if (server == null) {
            throw new UnsupportedOperationException("Server has not yet been initialized!");
        }
        return server.getVersion0();
    }

    public static String getServerSoftwareVersion() {
        if (server == null) {
            throw new UnsupportedOperationException("Server has not yet been initialized!");
        }
        return server.getServerSoftwareVersion0();
    }

    public static boolean isVersion(int major, int minor) {
        if (server == null) {
            throw new UnsupportedOperationException("Server has not yet been initialized!");
        }
        return server.isVersion0(major, minor);
    }

    public static boolean isVersion(int major, int minor, int patch) {
        if (server == null) {
            throw new UnsupportedOperationException("Server has not yet been initialized!");
        }
        return server.isVersion0(major, minor, patch);
    }

    public static List<PlayerWrapper> getConnectedPlayers() {
        if (server == null) {
            throw new UnsupportedOperationException("Server has not yet been initialized!");
        }
        return server.getConnectedPlayers0();
    }

    public static List<WorldHolder> getWorlds() {
        if (server == null) {
            throw new UnsupportedOperationException("Server has not yet been initialized!");
        }
        return server.getWorlds0();
    }

    public static List<PlayerWrapper> getConnectedPlayersFromWorld(WorldHolder world) {
        if (server == null) {
            throw new UnsupportedOperationException("Server has not yet been initialized!");
        }
        if (world == null) {
            throw new UnsupportedOperationException("Invalid world provided!");
        }
        return server.getConnectedPlayersFromWorld0(world);
    }

    public static void runSynchronously(Runnable task) {
        if (server == null) {
            throw new UnsupportedOperationException("Server has not yet been initialized!");
        }
        if (task == null) {
            throw new UnsupportedOperationException("Invalid task provided!");
        }
        server.runSynchronously0(task);
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    public static String UNSAFE_normalizeSoundKey(String s) {
        if (server == null) {
            throw new UnsupportedOperationException("Server has not yet been initialized!");
        }
        return server.UNSAFE_normalizeSoundKey0(s);
    }

    public static void shutdown() {
        if (server == null) {
            throw new UnsupportedOperationException("Server has not yet been initialized!");
        }
        server.shutdown0();
    }

    @ApiStatus.Experimental
    public static void UNSAFE_earlyInitializeLegacySupportAndIgnoreItsUsage() {
        if (server == null) {
            throw new UnsupportedOperationException("Server has not yet been initialized!");
        }
        server.UNSAFE_earlyInitializeLegacySupportAndIgnoreItsUsage0();
    }

    public abstract String getVersion0();

    public abstract String getServerSoftwareVersion0();

    public static List<ChannelFuture> getConnections() {
        if (server == null) {
            throw new UnsupportedOperationException("Server has not yet been initialized!");
        }
        return server.getConnections0();
    }

    public abstract boolean isVersion0(int var1, int var2);

    public abstract boolean isVersion0(int var1, int var2, int var3);

    public abstract boolean isServerThread0();

    public abstract List<PlayerWrapper> getConnectedPlayers0();

    public abstract List<PlayerWrapper> getConnectedPlayersFromWorld0(WorldHolder var1);

    public abstract List<WorldHolder> getWorlds0();

    public abstract void runSynchronously0(Runnable var1);

    public abstract List<ChannelFuture> getConnections0();

    public abstract void shutdown0();

    public String UNSAFE_normalizeSoundKey0(String s) {
        return s;
    }

    @ApiStatus.OverrideOnly
    public void UNSAFE_earlyInitializeLegacySupportAndIgnoreItsUsage0() {
    }
}

