/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib;

import io.github.pronze.lib.screaminglib.Server;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.CustomAutocompletion;
import io.github.pronze.lib.screaminglib.utils.key.NamespacedMappingKey;
import java.util.Optional;
import java.util.regex.Matcher;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class SpecialSoundKey
extends NamespacedMappingKey {
    protected SpecialSoundKey(String namespace, String key) {
        super(namespace, key);
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.SOUND)
    public static Optional<SpecialSoundKey> keyOptional(String combinedString) {
        Matcher matcher = RESOLUTION_PATTERN.matcher(combinedString);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        String namespace = matcher.group("namespace") != null ? matcher.group("namespace").toLowerCase() : "minecraft";
        String key = matcher.group("key").replaceAll(" ", "_").toLowerCase();
        return SpecialSoundKey.keyOptional(namespace, key);
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.SOUND)
    public static SpecialSoundKey key(String combinedString) {
        return SpecialSoundKey.keyOptional(combinedString).orElseThrow(() -> new IllegalArgumentException(combinedString + " doesn't match validation patterns!"));
    }

    public static Optional<SpecialSoundKey> keyOptional(String namespace, String key) {
        if (!VALID_NAMESPACE.matcher(namespace).matches() || !VALID_KEY.matcher(key).matches()) {
            return Optional.empty();
        }
        if (namespace.equals("minecraft")) {
            key = Server.UNSAFE_normalizeSoundKey(key);
        }
        return Optional.of(new SpecialSoundKey(namespace, key));
    }

    public static SpecialSoundKey key(String namespace, String key) {
        return SpecialSoundKey.keyOptional(namespace, key).orElseThrow(() -> new IllegalArgumentException(namespace + ":" + key + " doesn't match validation patterns!"));
    }
}

