/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.attribute;

import io.github.pronze.lib.screaminglib.attribute.AttributeMapping;
import io.github.pronze.lib.screaminglib.attribute.AttributeModifierHolder;
import io.github.pronze.lib.screaminglib.attribute.AttributeTypeHolder;
import io.github.pronze.lib.screaminglib.slot.EquipmentSlotHolder;
import io.github.pronze.lib.screaminglib.utils.ProtoItemAttribute;
import io.github.pronze.lib.screaminglib.utils.ProtoWrapper;
import io.github.pronze.lib.screaminglib.utils.Wrapper;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class ItemAttributeHolder
implements Wrapper,
ProtoWrapper<ProtoItemAttribute> {
    private final AttributeTypeHolder type;
    private final UUID uuid;
    private final String name;
    private final double amount;
    private final AttributeModifierHolder.Operation operation;
    @Nullable
    private final EquipmentSlotHolder slot;

    @Override
    public <T> T as(Class<T> type) {
        return AttributeMapping.convertItemAttributeHolder(this, type);
    }

    @Override
    public ProtoItemAttribute asProto() {
        ProtoItemAttribute.Builder builder = ProtoItemAttribute.newBuilder().setType(this.type.platformName()).setUuid(this.uuid.toString()).setName(this.name).setAmount(this.amount).setOperation(this.operation.name());
        if (this.slot != null && this.slot.platformName() != null) {
            builder.setSlot(this.slot.platformName());
        }
        return builder.build();
    }

    public ItemAttributeHolder(AttributeTypeHolder type, UUID uuid, String name, double amount, AttributeModifierHolder.Operation operation, @Nullable EquipmentSlotHolder slot) {
        this.type = type;
        this.uuid = uuid;
        this.name = name;
        this.amount = amount;
        this.operation = operation;
        this.slot = slot;
    }

    public AttributeTypeHolder getType() {
        return this.type;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public double getAmount() {
        return this.amount;
    }

    public AttributeModifierHolder.Operation getOperation() {
        return this.operation;
    }

    @Nullable
    public EquipmentSlotHolder getSlot() {
        return this.slot;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemAttributeHolder)) {
            return false;
        }
        ItemAttributeHolder other = (ItemAttributeHolder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getAmount(), other.getAmount()) != 0) {
            return false;
        }
        AttributeTypeHolder this$type = this.getType();
        AttributeTypeHolder other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        AttributeModifierHolder.Operation this$operation = this.getOperation();
        AttributeModifierHolder.Operation other$operation = other.getOperation();
        if (this$operation == null ? other$operation != null : !((Object)((Object)this$operation)).equals((Object)other$operation)) {
            return false;
        }
        EquipmentSlotHolder this$slot = this.getSlot();
        EquipmentSlotHolder other$slot = other.getSlot();
        return !(this$slot == null ? other$slot != null : !this$slot.equals(other$slot));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ItemAttributeHolder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $amount = Double.doubleToLongBits(this.getAmount());
        result = result * 59 + (int)($amount >>> 32 ^ $amount);
        AttributeTypeHolder $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        AttributeModifierHolder.Operation $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : ((Object)((Object)$operation)).hashCode());
        EquipmentSlotHolder $slot = this.getSlot();
        result = result * 59 + ($slot == null ? 43 : $slot.hashCode());
        return result;
    }

    public String toString() {
        return "ItemAttributeHolder(type=" + this.getType() + ", uuid=" + this.getUuid() + ", name=" + this.getName() + ", amount=" + this.getAmount() + ", operation=" + this.getOperation() + ", slot=" + this.getSlot() + ")";
    }
}

