/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.block;

import io.github.pronze.lib.screaminglib.block.BlockMapper;
import io.github.pronze.lib.screaminglib.block.BlockTypeHolder;
import io.github.pronze.lib.screaminglib.block.state.BlockStateHolder;
import io.github.pronze.lib.screaminglib.block.state.BlockStateMapper;
import io.github.pronze.lib.screaminglib.utils.Wrapper;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;

public class BlockHolder
implements Wrapper {
    private final LocationHolder location;
    private BlockTypeHolder type;

    @ApiStatus.Internal
    public BlockHolder(LocationHolder location, BlockTypeHolder type) {
        this.location = location;
        this.type = type;
    }

    public void setType(BlockTypeHolder type) {
        BlockMapper.setBlockAt(this.location, type, false);
        this.type = type;
    }

    @ApiStatus.Experimental
    public void setTypeWithoutPhysics(BlockTypeHolder type) {
        BlockMapper.setBlockAt(this.location, type, true);
        this.type = type;
    }

    public BlockTypeHolder getCurrentType() {
        BlockTypeHolder toReturn;
        this.type = toReturn = BlockMapper.getBlockAt(this.location).getType();
        return toReturn;
    }

    public <T extends BlockStateHolder> Optional<T> getBlockState() {
        return BlockStateMapper.getBlockStateFromBlock(this);
    }

    public void breakNaturally() {
        BlockMapper.breakNaturally(this.location);
    }

    public boolean isEmpty() {
        return this.type.isAir();
    }

    @Override
    public <T> T as(Class<T> type) {
        return BlockMapper.convert(this, type);
    }

    public LocationHolder getLocation() {
        return this.location;
    }

    public BlockTypeHolder getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockHolder)) {
            return false;
        }
        BlockHolder other = (BlockHolder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LocationHolder this$location = this.getLocation();
        LocationHolder other$location = other.getLocation();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        BlockTypeHolder this$type = this.getType();
        BlockTypeHolder other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlockHolder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocationHolder $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        BlockTypeHolder $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "BlockHolder(location=" + this.getLocation() + ", type=" + this.getType() + ")";
    }
}

