/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.block;

import io.github.pronze.lib.screaminglib.block.BlockHolder;
import io.github.pronze.lib.screaminglib.block.BlockTypeHolder;
import io.github.pronze.lib.screaminglib.block.BlockTypeMapper;
import io.github.pronze.lib.screaminglib.utils.BidirectionalConverter;
import io.github.pronze.lib.screaminglib.utils.annotations.AbstractService;
import io.github.pronze.lib.screaminglib.utils.annotations.ServiceDependencies;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import io.github.pronze.lib.screaminglib.world.LocationMapper;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;

@AbstractService
@ServiceDependencies(dependsOn={LocationMapper.class, BlockTypeMapper.class})
public abstract class BlockMapper {
    protected BidirectionalConverter<BlockHolder> converter = BidirectionalConverter.build().registerP2W(BlockHolder.class, e -> e);
    private static BlockMapper mapping;

    @ApiStatus.Internal
    public BlockMapper() {
        if (mapping != null) {
            throw new UnsupportedOperationException("BlockMapper is already initialized.");
        }
        mapping = this;
    }

    public static Optional<BlockHolder> resolve(Object obj) {
        if (mapping == null) {
            throw new UnsupportedOperationException("BlockMapper is not initialized yet.");
        }
        return BlockMapper.mapping.converter.convertOptional(obj);
    }

    public static <T> BlockHolder wrapBlock(T block) {
        if (mapping == null) {
            throw new UnsupportedOperationException("BlockMapper is not initialized yet.");
        }
        return BlockMapper.mapping.converter.convert(block);
    }

    public static <T> T convert(BlockHolder holder, Class<T> newType) {
        if (mapping == null) {
            throw new UnsupportedOperationException("BlockMapper is not initialized yet.");
        }
        return BlockMapper.mapping.converter.convert(holder, newType);
    }

    public static BlockHolder getBlockAt(LocationHolder location) {
        if (mapping == null) {
            throw new UnsupportedOperationException("BlockMapper is already initialized.");
        }
        return mapping.getBlockAt0(location);
    }

    public static void setBlockAt(LocationHolder location, BlockTypeHolder material, boolean ignorePhysics) {
        if (mapping == null) {
            throw new UnsupportedOperationException("BlockMapper is already initialized.");
        }
        mapping.setBlockAt0(location, material, ignorePhysics);
    }

    public static void breakNaturally(LocationHolder location) {
        if (mapping == null) {
            throw new UnsupportedOperationException("BlockMapper is already initialized.");
        }
        mapping.breakNaturally0(location);
    }

    protected abstract BlockHolder getBlockAt0(LocationHolder var1);

    protected abstract void setBlockAt0(LocationHolder var1, BlockTypeHolder var2, boolean var3);

    protected abstract void breakNaturally0(LocationHolder var1);
}

