/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.block;

import io.github.pronze.lib.screaminglib.block.BlockTypeMapper;
import io.github.pronze.lib.screaminglib.particle.ParticleData;
import io.github.pronze.lib.screaminglib.utils.ComparableWrapper;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.CustomAutocompletion;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;

public interface BlockTypeHolder
extends ComparableWrapper,
ParticleData {
    public String platformName();

    @Deprecated
    public byte legacyData();

    @Deprecated
    @Contract(value="_ -> new", pure=true)
    public BlockTypeHolder withLegacyData(byte var1);

    public @Unmodifiable Map<String, String> flatteningData();

    @Contract(value="_ -> new", pure=true)
    public BlockTypeHolder withFlatteningData(Map<String, String> var1);

    @Contract(value="_, _ -> new", pure=true)
    public BlockTypeHolder with(String var1, String var2);

    @Contract(value="_, _ -> new", pure=true)
    public BlockTypeHolder with(String var1, int var2);

    @Contract(value="_, _ -> new", pure=true)
    public BlockTypeHolder with(String var1, boolean var2);

    @Contract(value="_ -> new", pure=true)
    default public BlockTypeHolder colorize(String color) {
        return BlockTypeMapper.colorize(this, color);
    }

    public Optional<String> get(String var1);

    public Optional<Integer> getInt(String var1);

    public Optional<Boolean> getBoolean(String var1);

    default public boolean isAir() {
        return this.isSameType(BlockTypeHolder.air(), "minecraft:cave_air", "minecraft:void_air");
    }

    public boolean isSolid();

    public boolean isTransparent();

    public boolean isFlammable();

    public boolean isBurnable();

    public boolean isOccluding();

    public boolean hasGravity();

    @CustomAutocompletion(value=CustomAutocompletion.Type.BLOCK)
    public boolean isSameType(Object var1);

    @CustomAutocompletion(value=CustomAutocompletion.Type.BLOCK)
    public boolean isSameType(Object ... var1);

    @Override
    @CustomAutocompletion(value=CustomAutocompletion.Type.BLOCK)
    public boolean is(Object var1);

    @Override
    @CustomAutocompletion(value=CustomAutocompletion.Type.BLOCK)
    public boolean is(Object ... var1);

    @CustomAutocompletion(value=CustomAutocompletion.Type.BLOCK)
    public static BlockTypeHolder of(Object type) {
        return BlockTypeHolder.ofOptional(type).orElseThrow();
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.BLOCK)
    public static Optional<BlockTypeHolder> ofOptional(Object type) {
        if (type instanceof BlockTypeHolder) {
            return Optional.of((BlockTypeHolder)type);
        }
        return BlockTypeMapper.resolve(type);
    }

    public static BlockTypeHolder air() {
        return BlockTypeMapper.getCachedAir();
    }

    public static List<BlockTypeHolder> all() {
        return BlockTypeMapper.getValues();
    }
}

