/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.block.state;

import io.github.pronze.lib.screaminglib.block.BlockHolder;
import io.github.pronze.lib.screaminglib.block.state.BlockStateHolder;
import io.github.pronze.lib.screaminglib.utils.annotations.AbstractService;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;

@AbstractService(pattern="^(?<basePackage>.+)\\.(?<subPackage>[^\\.]+\\.[^\\.]+)\\.(?<className>.+)$")
public abstract class BlockStateMapper {
    private static BlockStateMapper blockStateMapper;

    @ApiStatus.Internal
    public BlockStateMapper() {
        if (blockStateMapper != null) {
            throw new UnsupportedOperationException("BlockStateMapper is already initialized.");
        }
        blockStateMapper = this;
    }

    public static <T extends BlockStateHolder> Optional<T> wrapBlockState(Object blockState) {
        if (blockStateMapper == null) {
            throw new UnsupportedOperationException("BlockStateMapper is not initialized yet.");
        }
        if (blockState instanceof BlockStateHolder) {
            return Optional.of((BlockStateHolder)blockState);
        }
        return blockStateMapper.wrapBlockState0(blockState);
    }

    protected abstract <T extends BlockStateHolder> Optional<T> wrapBlockState0(Object var1);

    public static <T extends BlockStateHolder> Optional<T> getBlockStateFromBlock(BlockHolder blockHolder) {
        if (blockStateMapper == null) {
            throw new UnsupportedOperationException("BlockStateMapper is not initialized yet.");
        }
        return blockStateMapper.getBlockStateFromBlock0(blockHolder);
    }

    protected abstract <T extends BlockStateHolder> Optional<T> getBlockStateFromBlock0(BlockHolder var1);
}

