/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit;

import io.github.pronze.lib.screaminglib.Server;
import io.github.pronze.lib.screaminglib.bukkit.block.BukkitBlockTypeHolder;
import io.github.pronze.lib.screaminglib.bukkit.utils.nms.ClassStorage;
import io.github.pronze.lib.screaminglib.bukkit.utils.nms.Version;
import io.github.pronze.lib.screaminglib.nms.accessors.MinecraftServerAccessor;
import io.github.pronze.lib.screaminglib.nms.accessors.ServerConnectionListenerAccessor;
import io.github.pronze.lib.screaminglib.player.PlayerMapper;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;
import io.github.pronze.lib.screaminglib.world.WorldHolder;
import io.github.pronze.lib.screaminglib.world.WorldMapper;
import io.netty.channel.ChannelFuture;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

@Service
public class BukkitServer
extends Server {
    private final Plugin plugin;
    private final Map<String, String> UNSAFE_SOUND_CACHE = new HashMap<String, String>();

    @Override
    public String getVersion0() {
        if (Version.PATCH_VERSION == 0) {
            return Version.MAJOR_VERSION + "." + Version.MINOR_VERSION;
        }
        return Version.MAJOR_VERSION + "." + Version.MINOR_VERSION + "." + Version.PATCH_VERSION;
    }

    @Override
    public String getServerSoftwareVersion0() {
        return Bukkit.getVersion();
    }

    @Override
    public boolean isVersion0(int major, int minor) {
        return Version.isVersion(major, minor);
    }

    @Override
    public boolean isVersion0(int major, int minor, int patch) {
        return Version.isVersion(major, minor, patch);
    }

    @Override
    public boolean isServerThread0() {
        return Bukkit.getServer().isPrimaryThread();
    }

    @Override
    public List<PlayerWrapper> getConnectedPlayers0() {
        return Bukkit.getOnlinePlayers().stream().map(PlayerMapper::wrapPlayer).collect(Collectors.toList());
    }

    @Override
    public List<PlayerWrapper> getConnectedPlayersFromWorld0(WorldHolder holder) {
        return holder.as(World.class).getPlayers().stream().map(PlayerMapper::wrapPlayer).collect(Collectors.toList());
    }

    @Override
    public List<WorldHolder> getWorlds0() {
        return Bukkit.getWorlds().stream().map(WorldMapper::wrapWorld).collect(Collectors.toList());
    }

    @Override
    public void runSynchronously0(Runnable task) {
        Bukkit.getServer().getScheduler().runTask(this.plugin, task);
    }

    @Override
    public List<ChannelFuture> getConnections0() {
        return (List)Reflect.fastInvokeResulted((Object)Bukkit.getServer(), "getServer").getFieldResulted(MinecraftServerAccessor.getFieldConnection()).getFieldResulted(ServerConnectionListenerAccessor.getFieldChannels()).raw();
    }

    @Override
    public void shutdown0() {
        Bukkit.shutdown();
    }

    @Override
    public String UNSAFE_normalizeSoundKey0(String s) {
        if (this.UNSAFE_SOUND_CACHE.containsKey(s.toUpperCase())) {
            return this.UNSAFE_SOUND_CACHE.get(s.toUpperCase());
        }
        return super.UNSAFE_normalizeSoundKey0(s);
    }

    @Override
    public void UNSAFE_earlyInitializeLegacySupportAndIgnoreItsUsage0() {
        if (this.isVersion0(1, 13)) {
            ClassStorage.CB.UNSAFE_EVIL_GET_OUT_getCraftLegacy();
            BukkitBlockTypeHolder.NAG_AUTHOR_ABOUT_LEGACY_METHOD_USED = true;
        }
    }

    public BukkitServer(Plugin plugin) {
        try {
            if (Reflect.hasMethod(Sound.class, "getKey", new Class[0])) {
                for (Sound v : Sound.values()) {
                    if (!v.getKey().namespace().equals("minecraft")) continue;
                    this.UNSAFE_SOUND_CACHE.put(v.name(), v.getKey().value());
                }
            } else {
                for (Sound v : Sound.values()) {
                    Object craftSound = Reflect.getMethod(ClassStorage.CB.CraftSound, "getSound", Sound.class).invokeStatic(v);
                    this.UNSAFE_SOUND_CACHE.put(v.name(), craftSound.toString());
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.plugin = plugin;
    }
}

