/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.attribute;

import io.github.pronze.lib.screaminglib.attribute.AttributeHolder;
import io.github.pronze.lib.screaminglib.attribute.AttributeMapping;
import io.github.pronze.lib.screaminglib.attribute.AttributeModifierHolder;
import io.github.pronze.lib.screaminglib.attribute.AttributeTypeHolder;
import io.github.pronze.lib.screaminglib.attribute.ItemAttributeHolder;
import io.github.pronze.lib.screaminglib.bukkit.attribute.BukkitAttributeHolder;
import io.github.pronze.lib.screaminglib.bukkit.attribute.BukkitItemAttribute;
import io.github.pronze.lib.screaminglib.slot.EquipmentSlotHolder;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import java.util.Optional;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.EquipmentSlot;

@Service
public class BukkitAttributeMapping
extends AttributeMapping {
    public BukkitAttributeMapping() {
        this.attributeModifierConverter.registerW2P(AttributeModifier.class, holder -> new AttributeModifier(holder.getUuid(), holder.getName(), holder.getAmount(), AttributeModifier.Operation.values()[holder.getOperation().ordinal()])).registerP2W(AttributeModifier.class, attributeModifier -> new AttributeModifierHolder(attributeModifier.getUniqueId(), attributeModifier.getName(), attributeModifier.getAmount(), AttributeModifierHolder.Operation.byOrdinal(attributeModifier.getOperation().ordinal())));
        this.itemAttributeConverter.registerW2P(BukkitItemAttribute.class, holder -> {
            AttributeModifier modifier;
            try {
                modifier = new AttributeModifier(holder.getUuid(), holder.getName(), holder.getAmount(), AttributeModifier.Operation.values()[holder.getOperation().ordinal()], holder.getSlot() != null ? holder.getSlot().as(EquipmentSlot.class) : null);
            }
            catch (Throwable throwable) {
                modifier = new AttributeModifier(holder.getUuid(), holder.getName(), holder.getAmount(), AttributeModifier.Operation.values()[holder.getOperation().ordinal()]);
            }
            return new BukkitItemAttribute(holder.getType().as(Attribute.class), modifier);
        }).registerP2W(BukkitItemAttribute.class, bukkitItemAttribute -> {
            try {
                return new ItemAttributeHolder(AttributeTypeHolder.of(bukkitItemAttribute.getAttribute()), bukkitItemAttribute.getAttributeModifier().getUniqueId(), bukkitItemAttribute.getAttributeModifier().getName(), bukkitItemAttribute.getAttributeModifier().getAmount(), AttributeModifierHolder.Operation.values()[bukkitItemAttribute.getAttributeModifier().getOperation().ordinal()], EquipmentSlotHolder.ofOptional(bukkitItemAttribute.getAttributeModifier().getOperation()).orElse(null));
            }
            catch (Throwable throwable) {
                return new ItemAttributeHolder(AttributeTypeHolder.of(bukkitItemAttribute.getAttribute()), bukkitItemAttribute.getAttributeModifier().getUniqueId(), bukkitItemAttribute.getAttributeModifier().getName(), bukkitItemAttribute.getAttributeModifier().getAmount(), AttributeModifierHolder.Operation.values()[bukkitItemAttribute.getAttributeModifier().getOperation().ordinal()], null);
            }
        });
    }

    @Override
    protected Optional<AttributeHolder> wrapAttribute0(Object attribute) {
        if (attribute instanceof AttributeInstance) {
            return Optional.of(new BukkitAttributeHolder((AttributeInstance)attribute));
        }
        return Optional.empty();
    }
}

