/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.block;

import io.github.pronze.lib.screaminglib.block.BlockHolder;
import io.github.pronze.lib.screaminglib.block.BlockMapper;
import io.github.pronze.lib.screaminglib.block.BlockTypeHolder;
import io.github.pronze.lib.screaminglib.bukkit.utils.nms.Version;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import io.github.pronze.lib.screaminglib.world.LocationMapper;
import io.papermc.lib.PaperLib;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;

@Service
public class BukkitBlockMapper
extends BlockMapper {
    public BukkitBlockMapper() {
        this.converter.registerP2W(Location.class, location -> {
            Block block = location.getBlock();
            LocationHolder instanced = LocationMapper.resolve(block.getLocation()).orElseThrow();
            if (!Version.isVersion(1, 13)) {
                return new BlockHolder(instanced, BlockTypeHolder.of(block.getState().getData()));
            }
            return new BlockHolder(instanced, BlockTypeHolder.of(block.getBlockData()));
        }).registerP2W(Block.class, block -> BukkitBlockMapper.resolve(block.getLocation()).orElseThrow()).registerP2W(LocationHolder.class, location -> BukkitBlockMapper.resolve(location.as(Location.class)).orElseThrow()).registerW2P(Block.class, holder -> {
            Location location = holder.getLocation().as(Location.class);
            return location.getBlock();
        });
        if (Reflect.has("org.bukkit.block.data.BlockData")) {
            this.converter.registerW2P(BlockData.class, holder -> holder.getType().as(BlockData.class));
        }
    }

    @Override
    protected BlockHolder getBlockAt0(LocationHolder location) {
        return BukkitBlockMapper.resolve(location).orElseThrow();
    }

    @Override
    protected void setBlockAt0(LocationHolder location, BlockTypeHolder material, boolean ignorePhysics) {
        Location bukkitLocation = location.as(Location.class);
        PaperLib.getChunkAtAsync(bukkitLocation).thenAccept(result -> {
            if (!Version.isVersion(1, 13)) {
                bukkitLocation.getBlock().setType(material.as(Material.class), !ignorePhysics);
                Reflect.getMethod((Object)bukkitLocation.getBlock(), "setData", Byte.TYPE, Boolean.TYPE).invoke(material.legacyData(), !ignorePhysics);
            } else {
                bukkitLocation.getBlock().setBlockData(material.as(BlockData.class), !ignorePhysics);
            }
        });
    }

    @Override
    protected void breakNaturally0(LocationHolder location) {
        location.as(Location.class).getBlock().breakNaturally();
    }
}

