/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.block;

import io.github.pronze.lib.screaminglib.block.BlockTypeHolder;
import io.github.pronze.lib.screaminglib.utils.BasicWrapper;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.material.MaterialData;
import org.jetbrains.annotations.Unmodifiable;

public class BukkitBlockTypeLegacyHolder
extends BasicWrapper<MaterialData>
implements BlockTypeHolder {
    public BukkitBlockTypeLegacyHolder(Material material) {
        this(material.getNewData((byte)0));
    }

    public BukkitBlockTypeLegacyHolder(Material material, byte legacyData) {
        this(material.getNewData(legacyData));
    }

    public BukkitBlockTypeLegacyHolder(MaterialData wrappedObject) {
        super(wrappedObject);
        if (!wrappedObject.getItemType().isBlock()) {
            throw new UnsupportedOperationException("Material must be a block!");
        }
    }

    @Override
    public String platformName() {
        return ((MaterialData)this.wrappedObject).getItemType().name();
    }

    @Override
    public byte legacyData() {
        return ((MaterialData)this.wrappedObject).getData();
    }

    @Override
    public BlockTypeHolder withLegacyData(byte legacyData) {
        MaterialData clone = ((MaterialData)this.wrappedObject).clone();
        clone.setData(legacyData);
        return new BukkitBlockTypeLegacyHolder(clone);
    }

    @Override
    public @Unmodifiable Map<String, String> flatteningData() {
        return Map.of();
    }

    @Override
    public BlockTypeHolder withFlatteningData(Map<String, String> flatteningData) {
        return new BukkitBlockTypeLegacyHolder((MaterialData)this.wrappedObject);
    }

    @Override
    public BlockTypeHolder with(String attribute, String value) {
        return new BukkitBlockTypeLegacyHolder((MaterialData)this.wrappedObject);
    }

    @Override
    public BlockTypeHolder with(String attribute, int value) {
        return new BukkitBlockTypeLegacyHolder((MaterialData)this.wrappedObject);
    }

    @Override
    public BlockTypeHolder with(String attribute, boolean value) {
        return new BukkitBlockTypeLegacyHolder((MaterialData)this.wrappedObject);
    }

    @Override
    public Optional<String> get(String attribute) {
        return Optional.empty();
    }

    @Override
    public Optional<Integer> getInt(String attribute) {
        return Optional.empty();
    }

    @Override
    public Optional<Boolean> getBoolean(String attribute) {
        return Optional.empty();
    }

    @Override
    public boolean isSolid() {
        return ((MaterialData)this.wrappedObject).getItemType().isSolid();
    }

    @Override
    public boolean isTransparent() {
        return ((MaterialData)this.wrappedObject).getItemType().isTransparent();
    }

    @Override
    public boolean isFlammable() {
        return ((MaterialData)this.wrappedObject).getItemType().isFlammable();
    }

    @Override
    public boolean isBurnable() {
        return ((MaterialData)this.wrappedObject).getItemType().isBurnable();
    }

    @Override
    public boolean isOccluding() {
        return ((MaterialData)this.wrappedObject).getItemType().isOccluding();
    }

    @Override
    public boolean hasGravity() {
        return ((MaterialData)this.wrappedObject).getItemType().hasGravity();
    }

    @Override
    public boolean isSameType(Object object) {
        if (object instanceof Material) {
            return ((MaterialData)this.wrappedObject).getItemType() == object;
        }
        if (object instanceof MaterialData) {
            return ((MaterialData)this.wrappedObject).getItemType() == ((MaterialData)object).getItemType();
        }
        return BlockTypeHolder.ofOptional(object).map(h -> h.platformName().equals(this.platformName())).orElse(false);
    }

    @Override
    public boolean isSameType(Object ... objects) {
        return Arrays.stream(objects).anyMatch(this::isSameType);
    }

    @Override
    public boolean is(Object object) {
        if (object instanceof MaterialData || object instanceof BukkitBlockTypeLegacyHolder) {
            return this.equals(object);
        }
        return this.equals(BlockTypeHolder.ofOptional(object).orElse(null));
    }

    @Override
    public boolean is(Object ... objects) {
        return Arrays.stream(objects).anyMatch(this::is);
    }

    @Override
    public <T> T as(Class<T> type) {
        if (type == Material.class) {
            return (T)((MaterialData)this.wrappedObject).getItemType();
        }
        return super.as(type);
    }
}

