/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.block;

import com.google.common.base.Preconditions;
import io.github.pronze.lib.screaminglib.block.BlockTypeHolder;
import io.github.pronze.lib.screaminglib.block.BlockTypeMapper;
import io.github.pronze.lib.screaminglib.bukkit.block.BukkitBlockTypeHolder;
import io.github.pronze.lib.screaminglib.bukkit.block.BukkitBlockTypeLegacyHolder;
import io.github.pronze.lib.screaminglib.bukkit.utils.nms.Version;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.key.NamespacedMappingKey;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.material.MaterialData;

@Service
public class BukkitBlockTypeMapper
extends BlockTypeMapper {
    private final Map<String, Map<String, String>> defaultFlatteningBlockDataCache = new HashMap<String, Map<String, String>>();

    public BukkitBlockTypeMapper() {
        if (Version.isVersion(1, 13)) {
            this.blockTypeConverter.registerP2W(Material.class, BukkitBlockTypeHolder::new).registerP2W(BlockData.class, BukkitBlockTypeHolder::new);
            Arrays.stream(Material.values()).filter(t -> !t.name().startsWith("LEGACY") && t.isBlock()).forEach(material -> {
                BukkitBlockTypeHolder holder = new BukkitBlockTypeHolder((Material)material);
                this.mapping.put(NamespacedMappingKey.of(material.name()), holder);
                this.values.add(holder);
            });
        } else {
            this.blockTypeConverter.registerP2W(Material.class, BukkitBlockTypeLegacyHolder::new).registerP2W(MaterialData.class, BukkitBlockTypeLegacyHolder::new);
            Arrays.stream(Material.values()).filter(Material::isBlock).forEach(material -> {
                BukkitBlockTypeLegacyHolder holder = new BukkitBlockTypeLegacyHolder((Material)material);
                this.mapping.put(NamespacedMappingKey.of(material.name()), holder);
                this.values.add(holder);
            });
        }
    }

    @Override
    protected Map<String, String> getDataFromString(String data) {
        Preconditions.checkNotNull((Object)data, (Object)"Data cannot be null!");
        if (data.contains("[") && data.contains("]")) {
            String values = data.substring(data.indexOf("[") + 1, data.lastIndexOf("]"));
            if (values.isEmpty()) {
                return Map.of();
            }
            return Arrays.stream(values.split(",")).map(next -> next.split("=")).collect(Collectors.toMap(next -> next[0], next1 -> next1[1]));
        }
        return Map.of();
    }

    @Override
    protected BlockTypeHolder normalize(BlockTypeHolder abnormal) {
        try {
            if (Version.isVersion(1, 13)) {
                Map<String, String> cache = this.defaultFlatteningBlockDataCache.get(abnormal.platformName());
                if (cache == null) {
                    cache = this.getDataFromString(abnormal.as(Material.class).createBlockData().getAsString());
                    this.defaultFlatteningBlockDataCache.put(abnormal.platformName(), cache);
                }
                if (cache.isEmpty()) {
                    return abnormal;
                }
                Map<String, String> flatteningData = abnormal.flatteningData();
                if (flatteningData != null && !flatteningData.isEmpty()) {
                    HashMap<String, String> clone = new HashMap<String, String>(flatteningData);
                    cache.forEach((s, s2) -> {
                        if (!clone.containsKey(s)) {
                            clone.put((String)s, (String)s2);
                        }
                    });
                    return abnormal.withFlatteningData(clone);
                }
                return abnormal.withFlatteningData(cache);
            }
            return abnormal.withFlatteningData(null);
        }
        catch (Exception exception) {
            return abnormal;
        }
    }

    @Override
    protected boolean isLegacy() {
        return !Version.isVersion(1, 13);
    }
}

