/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.container;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.screaminglib.bukkit.container.BukkitContainer;
import io.github.pronze.lib.screaminglib.bukkit.container.BukkitPlayerContainer;
import io.github.pronze.lib.screaminglib.container.Container;
import io.github.pronze.lib.screaminglib.container.ContainerFactory;
import io.github.pronze.lib.screaminglib.container.type.InventoryTypeHolder;
import io.github.pronze.lib.screaminglib.utils.AdventureHelper;
import io.github.pronze.lib.screaminglib.utils.adventure.AdventureUtils;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.PlayerInventory;

@Service
public class BukkitContainerFactory
extends ContainerFactory {
    @Override
    public <C extends Container> Optional<C> wrapContainer0(Object container) {
        if (container instanceof PlayerInventory) {
            return Optional.of(new BukkitPlayerContainer((PlayerInventory)container));
        }
        if (container instanceof Inventory) {
            return Optional.of(new BukkitContainer((Inventory)container));
        }
        return Optional.empty();
    }

    @Override
    public <C extends Container> Optional<C> createContainer0(InventoryTypeHolder type) {
        return this.wrapContainer0(Bukkit.createInventory(null, (InventoryType)type.as(InventoryType.class)));
    }

    @Override
    public <C extends Container> Optional<C> createContainer0(InventoryTypeHolder type, Component name) {
        Inventory container = AdventureUtils.get(Bukkit.getServer(), "createInventory", InventoryHolder.class, InventoryType.class, Component.class).ifPresentOrElseGet(classMethod -> classMethod.invokeInstanceResulted(Bukkit.getServer(), null, type.as(InventoryType.class), name).as(Inventory.class), () -> Bukkit.createInventory(null, (InventoryType)type.as(InventoryType.class), (String)AdventureHelper.toLegacy(name)));
        return this.wrapContainer0(container);
    }

    @Override
    public <C extends Container> Optional<C> createContainer0(int size) {
        return this.wrapContainer0(Bukkit.createInventory(null, (int)size));
    }

    @Override
    public <C extends Container> Optional<C> createContainer0(int size, Component name) {
        Inventory container = AdventureUtils.get(Bukkit.getServer(), "createInventory", InventoryHolder.class, Integer.TYPE, Component.class).ifPresentOrElseGet(classMethod -> classMethod.invokeInstanceResulted(Bukkit.getServer(), null, size, name).as(Inventory.class), () -> Bukkit.createInventory(null, (int)size, (String)AdventureHelper.toLegacy(name)));
        return this.wrapContainer0(container);
    }
}

