/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.entity;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.util.RGBLike;
import io.github.pronze.lib.screaminglib.bukkit.entity.BukkitEntityMetadataMapper;
import io.github.pronze.lib.screaminglib.container.Container;
import io.github.pronze.lib.screaminglib.container.ContainerFactory;
import io.github.pronze.lib.screaminglib.entity.EntityBasic;
import io.github.pronze.lib.screaminglib.entity.EntityMapper;
import io.github.pronze.lib.screaminglib.entity.type.EntityTypeHolder;
import io.github.pronze.lib.screaminglib.utils.BasicWrapper;
import io.github.pronze.lib.screaminglib.utils.adventure.ComponentObjectLink;
import io.github.pronze.lib.screaminglib.utils.math.Vector3D;
import io.github.pronze.lib.screaminglib.utils.math.Vector3Df;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import io.github.pronze.lib.screaminglib.world.LocationMapper;
import io.papermc.lib.PaperLib;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

public class BukkitEntityBasic
extends BasicWrapper<Entity>
implements EntityBasic {
    public BukkitEntityBasic(Entity wrappedObject) {
        super(wrappedObject);
    }

    @Override
    public EntityTypeHolder getEntityType() {
        return EntityTypeHolder.of(((Entity)this.wrappedObject).getType());
    }

    @Override
    public LocationHolder getLocation() {
        return LocationMapper.wrapLocation(((Entity)this.wrappedObject).getLocation());
    }

    @Override
    public Vector3D getVelocity() {
        Vector platformVector = ((Entity)this.wrappedObject).getVelocity();
        return new Vector3D(platformVector.getX(), platformVector.getY(), platformVector.getZ());
    }

    @Override
    public void setVelocity(Vector3D velocity) {
        ((Entity)this.wrappedObject).setVelocity(new Vector(velocity.getX(), velocity.getY(), velocity.getZ()));
    }

    @Override
    public double getHeight() {
        return ((Entity)this.wrappedObject).getHeight();
    }

    @Override
    public double getWidth() {
        return ((Entity)this.wrappedObject).getWidth();
    }

    @Override
    public boolean isOnGround() {
        return ((Entity)this.wrappedObject).isOnGround();
    }

    @Override
    public boolean isInWater() {
        return ((Entity)this.wrappedObject).isInWater();
    }

    @Override
    public CompletableFuture<Boolean> teleport(LocationHolder locationHolder) {
        return PaperLib.teleportAsync((Entity)this.wrappedObject, locationHolder.as(Location.class));
    }

    @Override
    public CompletableFuture<Void> teleport(LocationHolder location, Runnable callback, boolean forceCallback) {
        return ((CompletableFuture)this.teleport(location).thenAccept(result -> {
            if (result.booleanValue() || forceCallback) {
                callback.run();
            }
        })).exceptionally(ex -> {
            ex.printStackTrace();
            return null;
        });
    }

    @Override
    public boolean teleportSync(LocationHolder location) {
        return ((Entity)this.wrappedObject).teleport(location.as(Location.class));
    }

    @Override
    public int getEntityId() {
        return ((Entity)this.wrappedObject).getEntityId();
    }

    @Override
    public int getFireTicks() {
        return ((Entity)this.wrappedObject).getFireTicks();
    }

    @Override
    public int getMaxFireTicks() {
        return ((Entity)this.wrappedObject).getMaxFireTicks();
    }

    @Override
    public void setFireTicks(int fireTicks) {
        ((Entity)this.wrappedObject).setFireTicks(fireTicks);
    }

    @Override
    public void remove() {
        ((Entity)this.wrappedObject).remove();
    }

    @Override
    public boolean isDead() {
        return ((Entity)this.wrappedObject).isDead();
    }

    @Override
    public boolean isPersistent() {
        return ((Entity)this.wrappedObject).isPersistent();
    }

    @Override
    public void setPersistent(boolean persistent) {
        ((Entity)this.wrappedObject).setPersistent(persistent);
    }

    @Override
    public List<EntityBasic> getPassengers() {
        return ((Entity)this.wrappedObject).getPassengers().stream().map(EntityMapper::wrapEntity).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    @Override
    public boolean addPassenger(EntityBasic passenger) {
        Entity bukkitPassenger = passenger.as(Entity.class);
        try {
            return ((Entity)this.wrappedObject).addPassenger(bukkitPassenger);
        }
        catch (Throwable ignored) {
            return ((Entity)this.wrappedObject).setPassenger(bukkitPassenger);
        }
    }

    @Override
    public boolean removePassenger(EntityBasic passenger) {
        try {
            return ((Entity)this.wrappedObject).removePassenger(passenger.as(Entity.class));
        }
        catch (Throwable ignored) {
            return ((Entity)this.wrappedObject).eject();
        }
    }

    @Override
    public boolean hasPassengers() {
        return !((Entity)this.wrappedObject).isEmpty();
    }

    @Override
    public boolean ejectPassengers() {
        return ((Entity)this.wrappedObject).eject();
    }

    @Override
    public float getFallDistance() {
        return ((Entity)this.wrappedObject).getFallDistance();
    }

    @Override
    public void setFallDistance(float distance) {
        ((Entity)this.wrappedObject).setFallDistance(distance);
    }

    @Override
    public UUID getUniqueId() {
        return ((Entity)this.wrappedObject).getUniqueId();
    }

    @Override
    public int getTicksLived() {
        return ((Entity)this.wrappedObject).getTicksLived();
    }

    @Override
    public void setTicksLived(int value) {
        ((Entity)this.wrappedObject).setTicksLived(value);
    }

    @Override
    public boolean isInsideVehicle() {
        return ((Entity)this.wrappedObject).isInsideVehicle();
    }

    @Override
    public boolean leaveVehicle() {
        return ((Entity)this.wrappedObject).leaveVehicle();
    }

    @Override
    public EntityBasic getVehicle() {
        return (EntityBasic)EntityMapper.wrapEntity(((Entity)this.wrappedObject).getVehicle()).orElseThrow();
    }

    @Override
    public void setCustomName(String name) {
        ((Entity)this.wrappedObject).setCustomName(name);
    }

    @Override
    public void setCustomName(Component name) {
        ComponentObjectLink.processSetter(this.wrappedObject, "customName", arg_0 -> ((Entity)((Entity)this.wrappedObject)).setCustomName(arg_0), name);
    }

    @Override
    @Nullable
    public Component getCustomName() {
        return ComponentObjectLink.processGetter(this.wrappedObject, "customName", () -> ((Entity)((Entity)this.wrappedObject)).getCustomName());
    }

    @Override
    public void setCustomNameVisible(boolean flag) {
        ((Entity)this.wrappedObject).setCustomNameVisible(flag);
    }

    @Override
    public boolean isCustomNameVisible() {
        return ((Entity)this.wrappedObject).isCustomNameVisible();
    }

    @Override
    public void setGlowing(boolean flag) {
        ((Entity)this.wrappedObject).setGlowing(flag);
    }

    @Override
    public boolean isGlowing() {
        return ((Entity)this.wrappedObject).isGlowing();
    }

    @Override
    public void setInvulnerable(boolean flag) {
        ((Entity)this.wrappedObject).setInvulnerable(flag);
    }

    @Override
    public boolean isInvulnerable() {
        return ((Entity)this.wrappedObject).isInvulnerable();
    }

    @Override
    public boolean isSilent() {
        return ((Entity)this.wrappedObject).isSilent();
    }

    @Override
    public void setSilent(boolean flag) {
        ((Entity)this.wrappedObject).setSilent(flag);
    }

    @Override
    public boolean hasGravity() {
        return ((Entity)this.wrappedObject).hasGravity();
    }

    @Override
    public void setGravity(boolean gravity) {
        ((Entity)this.wrappedObject).setGravity(gravity);
    }

    @Override
    public int getPortalCooldown() {
        return ((Entity)this.wrappedObject).getPortalCooldown();
    }

    @Override
    public void setPortalCooldown(int cooldown) {
        ((Entity)this.wrappedObject).setPortalCooldown(cooldown);
    }

    @Override
    public boolean hasMetadata(String metadata) {
        return BukkitEntityMetadataMapper.has((Entity)this.wrappedObject, metadata);
    }

    @Override
    public Object getMetadata(String metadata) {
        return BukkitEntityMetadataMapper.get((Entity)this.wrappedObject, metadata, Object.class);
    }

    @Override
    public int getIntMetadata(String metadata) {
        Integer i = BukkitEntityMetadataMapper.get((Entity)this.wrappedObject, metadata, Integer.class);
        return i == null ? 0 : i;
    }

    @Override
    public boolean getBooleanMetadata(String metadata) {
        Boolean b = BukkitEntityMetadataMapper.get((Entity)this.wrappedObject, metadata, Boolean.class);
        return b != null && b != false;
    }

    @Override
    public byte getByteMetadata(String metadata) {
        Byte b = BukkitEntityMetadataMapper.get((Entity)this.wrappedObject, metadata, Byte.class);
        return b == null ? (byte)0 : b;
    }

    @Override
    public long getLongMetadata(String metadata) {
        Long b = BukkitEntityMetadataMapper.get((Entity)this.wrappedObject, metadata, Long.class);
        return b == null ? 0L : b;
    }

    @Override
    public String getStringMetadata(String metadata) {
        return BukkitEntityMetadataMapper.get((Entity)this.wrappedObject, metadata, String.class);
    }

    @Override
    public Component getComponentMetadata(String metadata) {
        return BukkitEntityMetadataMapper.get((Entity)this.wrappedObject, metadata, Component.class);
    }

    @Override
    public LocationHolder getLocationMetadata(String metadata) {
        return BukkitEntityMetadataMapper.get((Entity)this.wrappedObject, metadata, LocationHolder.class);
    }

    @Override
    public RGBLike getColorMetadata(String metadata) {
        return BukkitEntityMetadataMapper.get((Entity)this.wrappedObject, metadata, RGBLike.class);
    }

    @Override
    public Vector3D getVectorMetadata(String metadata) {
        return BukkitEntityMetadataMapper.get((Entity)this.wrappedObject, metadata, Vector3D.class);
    }

    @Override
    public Vector3Df getFloatVectorMetadata(String metadata) {
        return BukkitEntityMetadataMapper.get((Entity)this.wrappedObject, metadata, Vector3Df.class);
    }

    @Override
    public void setMetadata(String metadata, Object value) {
        BukkitEntityMetadataMapper.set((Entity)this.wrappedObject, metadata, value);
    }

    @Override
    public boolean holdsInventory() {
        return this.wrappedObject instanceof InventoryHolder;
    }

    @Override
    public Optional<Container> getInventory() {
        if (!(this.wrappedObject instanceof InventoryHolder)) {
            return Optional.empty();
        }
        return ContainerFactory.wrapContainer(((InventoryHolder)this.wrappedObject).getInventory());
    }
}

