/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.entity;

import io.github.pronze.lib.screaminglib.attribute.AttributeHolder;
import io.github.pronze.lib.screaminglib.attribute.AttributeMapping;
import io.github.pronze.lib.screaminglib.attribute.AttributeTypeHolder;
import io.github.pronze.lib.screaminglib.block.BlockHolder;
import io.github.pronze.lib.screaminglib.block.BlockMapper;
import io.github.pronze.lib.screaminglib.block.BlockTypeHolder;
import io.github.pronze.lib.screaminglib.bukkit.entity.BukkitEntityBasic;
import io.github.pronze.lib.screaminglib.bukkit.item.BukkitItem;
import io.github.pronze.lib.screaminglib.entity.EntityBasic;
import io.github.pronze.lib.screaminglib.entity.EntityLiving;
import io.github.pronze.lib.screaminglib.entity.EntityMapper;
import io.github.pronze.lib.screaminglib.entity.EntityProjectile;
import io.github.pronze.lib.screaminglib.entity.type.EntityTypeHolder;
import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.item.meta.PotionEffectHolder;
import io.github.pronze.lib.screaminglib.item.meta.PotionEffectMapping;
import io.github.pronze.lib.screaminglib.utils.math.Vector3D;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import io.github.pronze.lib.screaminglib.world.LocationMapper;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

public class BukkitEntityLiving
extends BukkitEntityBasic
implements EntityLiving {
    public BukkitEntityLiving(LivingEntity wrappedObject) {
        super((Entity)wrappedObject);
    }

    @Override
    public Optional<AttributeHolder> getAttribute(AttributeTypeHolder attributeType) {
        return AttributeMapping.wrapAttribute(((LivingEntity)this.wrappedObject).getAttribute(attributeType.as(Attribute.class)));
    }

    @Override
    public double getEyeHeight() {
        return ((LivingEntity)this.wrappedObject).getEyeHeight();
    }

    @Override
    public double getEyeHeight(boolean ignorePose) {
        return ((LivingEntity)this.wrappedObject).getEyeHeight(ignorePose);
    }

    @Override
    public LocationHolder getEyeLocation() {
        return LocationMapper.wrapLocation(((LivingEntity)this.wrappedObject).getEyeLocation());
    }

    @Override
    public BlockHolder getTargetBlock(@Nullable Collection<BlockTypeHolder> transparent, int maxDistance) {
        return BlockMapper.wrapBlock(((LivingEntity)this.wrappedObject).getTargetBlock(transparent == null ? null : transparent.stream().map(material -> material.as(Material.class)).collect(Collectors.toSet()), maxDistance));
    }

    @Override
    public Optional<BlockHolder> getTargetBlock(int maxDistance) {
        return BlockMapper.resolve(((LivingEntity)this.wrappedObject).getTargetBlockExact(maxDistance));
    }

    @Override
    public int getRemainingAir() {
        return ((LivingEntity)this.wrappedObject).getRemainingAir();
    }

    @Override
    public void setRemainingAir(int ticks) {
        ((LivingEntity)this.wrappedObject).setRemainingAir(ticks);
    }

    @Override
    public int getMaximumAir() {
        return ((LivingEntity)this.wrappedObject).getMaximumAir();
    }

    @Override
    public void setMaximumAir(int ticks) {
        ((LivingEntity)this.wrappedObject).setMaximumAir(ticks);
    }

    @Override
    public int getArrowCooldown() {
        return ((LivingEntity)this.wrappedObject).getArrowCooldown();
    }

    @Override
    public void setArrowCooldown(int ticks) {
        ((LivingEntity)this.wrappedObject).setArrowCooldown(ticks);
    }

    @Override
    public int getArrowsInBody() {
        return ((LivingEntity)this.wrappedObject).getArrowsInBody();
    }

    @Override
    public void setArrowsInBody(int count) {
        ((LivingEntity)this.wrappedObject).setArrowsInBody(count);
    }

    @Override
    public int getMaximumNoDamageTicks() {
        return ((LivingEntity)this.wrappedObject).getMaximumNoDamageTicks();
    }

    @Override
    public void setMaximumNoDamageTicks(int ticks) {
        ((LivingEntity)this.wrappedObject).setMaximumNoDamageTicks(ticks);
    }

    @Override
    public double getLastDamage() {
        return ((LivingEntity)this.wrappedObject).getLastDamage();
    }

    @Override
    public void setLastDamage(double damage) {
        ((LivingEntity)this.wrappedObject).setLastDamage(damage);
    }

    @Override
    public int getNoDamageTicks() {
        return ((LivingEntity)this.wrappedObject).getNoDamageTicks();
    }

    @Override
    public void setNoDamageTicks(int ticks) {
        ((LivingEntity)this.wrappedObject).setNoDamageTicks(ticks);
    }

    @Override
    public Optional<EntityLiving> getHumanKiller() {
        Player player = ((LivingEntity)this.wrappedObject).getKiller();
        EntityBasic entity = EntityMapper.wrapEntity(player).orElse(null);
        if (entity instanceof EntityLiving) {
            return Optional.of((EntityLiving)entity);
        }
        return Optional.empty();
    }

    @Override
    public boolean addPotionEffect(PotionEffectHolder effect) {
        return ((LivingEntity)this.wrappedObject).addPotionEffect(effect.as(PotionEffect.class));
    }

    @Override
    public boolean addPotionEffects(Collection<PotionEffectHolder> effects) {
        return ((LivingEntity)this.wrappedObject).addPotionEffects((Collection)effects.stream().map(effect -> effect.as(PotionEffect.class)).collect(Collectors.toSet()));
    }

    @Override
    public boolean hasPotionEffect(PotionEffectHolder type) {
        return ((LivingEntity)this.wrappedObject).hasPotionEffect(type.as(PotionEffectType.class));
    }

    @Override
    public void removePotionEffect(PotionEffectHolder type) {
        ((LivingEntity)this.wrappedObject).removePotionEffect(type.as(PotionEffectType.class));
    }

    @Override
    public List<PotionEffectHolder> getActivePotionEffects() {
        return ((LivingEntity)this.wrappedObject).getActivePotionEffects().stream().map(potionEffect -> PotionEffectMapping.resolve(potionEffect).orElseThrow()).collect(Collectors.toList());
    }

    @Override
    public boolean getRemoveWhenFarAway() {
        return ((LivingEntity)this.wrappedObject).getRemoveWhenFarAway();
    }

    @Override
    public void setRemoveWhenFarAway(boolean remove) {
        ((LivingEntity)this.wrappedObject).setRemoveWhenFarAway(remove);
    }

    @Override
    public void setCanPickupItems(boolean pickup) {
        ((LivingEntity)this.wrappedObject).setCanPickupItems(pickup);
    }

    @Override
    public boolean getCanPickupItems() {
        return ((LivingEntity)this.wrappedObject).getCanPickupItems();
    }

    @Override
    public boolean isLeashed() {
        return ((LivingEntity)this.wrappedObject).isLeashed();
    }

    @Override
    public Optional<EntityBasic> getLeashHolder() {
        if (this.isLeashed()) {
            return EntityMapper.wrapEntity(((LivingEntity)this.wrappedObject).getLeashHolder());
        }
        return Optional.empty();
    }

    @Override
    public boolean setLeashHolder(EntityBasic holder) {
        return ((LivingEntity)this.wrappedObject).setLeashHolder(holder.as(Entity.class));
    }

    @Override
    public boolean removeLeashHolder() {
        return ((LivingEntity)this.wrappedObject).setLeashHolder(null);
    }

    @Override
    public boolean isGliding() {
        return ((LivingEntity)this.wrappedObject).isGliding();
    }

    @Override
    public void setGliding(boolean gliding) {
        ((LivingEntity)this.wrappedObject).setGliding(gliding);
    }

    @Override
    public boolean isSwimming() {
        return ((LivingEntity)this.wrappedObject).isSwimming();
    }

    @Override
    public void setSwimming(boolean swimming) {
        ((LivingEntity)this.wrappedObject).setSwimming(swimming);
    }

    @Override
    public boolean isRiptiding() {
        return ((LivingEntity)this.wrappedObject).isRiptiding();
    }

    @Override
    public boolean isSleeping() {
        return ((LivingEntity)this.wrappedObject).isSleeping();
    }

    @Override
    public void setAI(boolean ai) {
        ((LivingEntity)this.wrappedObject).setAI(ai);
    }

    @Override
    public boolean hasAI() {
        return ((LivingEntity)this.wrappedObject).hasAI();
    }

    @Override
    public void attack(EntityBasic target) {
        ((LivingEntity)this.wrappedObject).attack(target.as(Entity.class));
    }

    @Override
    public void swingMainHand() {
        ((LivingEntity)this.wrappedObject).swingMainHand();
    }

    @Override
    public void swingOffHand() {
        ((LivingEntity)this.wrappedObject).swingOffHand();
    }

    @Override
    public void setCollidable(boolean collidable) {
        ((LivingEntity)this.wrappedObject).setCollidable(collidable);
    }

    @Override
    public boolean isCollidable() {
        return ((LivingEntity)this.wrappedObject).isCollidable();
    }

    @Override
    public void setInvisible(boolean invisible) {
        ((LivingEntity)this.wrappedObject).setInvisible(invisible);
    }

    @Override
    public boolean isInvisible() {
        return ((LivingEntity)this.wrappedObject).isInvisible();
    }

    @Override
    public void damage(double amount) {
        ((LivingEntity)this.wrappedObject).damage(amount);
    }

    @Override
    public void damage(double amount, EntityBasic damageSource) {
        ((LivingEntity)this.wrappedObject).damage(amount, damageSource.as(Entity.class));
    }

    @Override
    public double getAbsorptionAmount() {
        return ((LivingEntity)this.wrappedObject).getAbsorptionAmount();
    }

    @Override
    public double getHealth() {
        return ((LivingEntity)this.wrappedObject).getHealth();
    }

    @Override
    public void setAbsorptionAmount(double amount) {
        ((LivingEntity)this.wrappedObject).setAbsorptionAmount(amount);
    }

    @Override
    public void setHealth(double health) {
        ((LivingEntity)this.wrappedObject).setHealth(health);
    }

    @Override
    @Nullable
    public Item getHelmet() {
        EntityEquipment eq = ((LivingEntity)this.wrappedObject).getEquipment();
        if (eq == null || eq.getHelmet() == null) {
            return null;
        }
        return new BukkitItem(eq.getHelmet());
    }

    @Override
    @Nullable
    public Item getChestplate() {
        EntityEquipment eq = ((LivingEntity)this.wrappedObject).getEquipment();
        if (eq == null || eq.getChestplate() == null) {
            return null;
        }
        return new BukkitItem(eq.getChestplate());
    }

    @Override
    @Nullable
    public Item getLeggings() {
        EntityEquipment eq = ((LivingEntity)this.wrappedObject).getEquipment();
        if (eq == null || eq.getLeggings() == null) {
            return null;
        }
        return new BukkitItem(eq.getLeggings());
    }

    @Override
    @Nullable
    public Item getBoots() {
        EntityEquipment eq = ((LivingEntity)this.wrappedObject).getEquipment();
        if (eq == null || eq.getBoots() == null) {
            return null;
        }
        return new BukkitItem(eq.getBoots());
    }

    @Override
    public void setHelmet(@Nullable Item helmet) {
        EntityEquipment eq = ((LivingEntity)this.wrappedObject).getEquipment();
        if (eq == null) {
            return;
        }
        if (helmet == null) {
            eq.setHelmet(null);
        } else {
            eq.setHelmet(helmet.as(ItemStack.class));
        }
    }

    @Override
    public void setChestplate(@Nullable Item chestplate) {
        EntityEquipment eq = ((LivingEntity)this.wrappedObject).getEquipment();
        if (eq == null) {
            return;
        }
        if (chestplate == null) {
            eq.setChestplate(null);
        } else {
            eq.setChestplate(chestplate.as(ItemStack.class));
        }
    }

    @Override
    public void setLeggings(@Nullable Item leggings) {
        EntityEquipment eq = ((LivingEntity)this.wrappedObject).getEquipment();
        if (eq == null) {
            return;
        }
        if (leggings == null) {
            eq.setLeggings(null);
        } else {
            eq.setLeggings(leggings.as(ItemStack.class));
        }
    }

    @Override
    public void setBoots(@Nullable Item boots) {
        EntityEquipment eq = ((LivingEntity)this.wrappedObject).getEquipment();
        if (eq == null) {
            return;
        }
        if (boots == null) {
            eq.setBoots(null);
        } else {
            eq.setBoots(boots.as(ItemStack.class));
        }
    }

    @Override
    @Nullable
    public Item getItemInMainHand() {
        EntityEquipment eq = ((LivingEntity)this.wrappedObject).getEquipment();
        if (eq == null) {
            return null;
        }
        return new BukkitItem(eq.getItemInMainHand());
    }

    @Override
    public void setItemInMainHand(@Nullable Item item) {
        EntityEquipment eq = ((LivingEntity)this.wrappedObject).getEquipment();
        if (eq == null) {
            return;
        }
        if (item == null) {
            eq.setItemInMainHand(null);
        } else {
            eq.setItemInMainHand(item.as(ItemStack.class));
        }
    }

    @Override
    @Nullable
    public Item getItemInOffHand() {
        EntityEquipment eq = ((LivingEntity)this.wrappedObject).getEquipment();
        if (eq == null) {
            return null;
        }
        return new BukkitItem(eq.getItemInOffHand());
    }

    @Override
    public void setItemInOffHand(@Nullable Item item) {
        EntityEquipment eq = ((LivingEntity)this.wrappedObject).getEquipment();
        if (eq == null) {
            return;
        }
        if (item == null) {
            eq.setItemInOffHand(null);
        } else {
            eq.setItemInOffHand(item.as(ItemStack.class));
        }
    }

    @Override
    public Optional<EntityProjectile> launchProjectile(EntityTypeHolder projectileType) {
        return EntityMapper.wrapEntity(((LivingEntity)this.wrappedObject).launchProjectile(projectileType.as(EntityType.class).getEntityClass()));
    }

    @Override
    public Optional<EntityProjectile> launchProjectile(EntityTypeHolder projectileType, Vector3D velocity) {
        return EntityMapper.wrapEntity(((LivingEntity)this.wrappedObject).launchProjectile(projectileType.as(EntityType.class).getEntityClass(), new Vector(velocity.getX(), velocity.getY(), velocity.getZ())));
    }
}

