/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.entity;

import io.github.pronze.lib.screaminglib.Server;
import io.github.pronze.lib.screaminglib.bukkit.entity.BukkitEntityBasic;
import io.github.pronze.lib.screaminglib.bukkit.entity.BukkitEntityExperience;
import io.github.pronze.lib.screaminglib.bukkit.entity.BukkitEntityFirework;
import io.github.pronze.lib.screaminglib.bukkit.entity.BukkitEntityHuman;
import io.github.pronze.lib.screaminglib.bukkit.entity.BukkitEntityItem;
import io.github.pronze.lib.screaminglib.bukkit.entity.BukkitEntityLightning;
import io.github.pronze.lib.screaminglib.bukkit.entity.BukkitEntityLiving;
import io.github.pronze.lib.screaminglib.bukkit.entity.BukkitEntityPathfindingMob;
import io.github.pronze.lib.screaminglib.bukkit.entity.BukkitEntityPlayer;
import io.github.pronze.lib.screaminglib.bukkit.entity.BukkitEntityProjectile;
import io.github.pronze.lib.screaminglib.entity.EntityBasic;
import io.github.pronze.lib.screaminglib.entity.EntityExperience;
import io.github.pronze.lib.screaminglib.entity.EntityItem;
import io.github.pronze.lib.screaminglib.entity.EntityLightning;
import io.github.pronze.lib.screaminglib.entity.EntityMapper;
import io.github.pronze.lib.screaminglib.entity.type.EntityTypeHolder;
import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.nms.accessors.EntityAccessor;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Firework;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Slime;
import org.bukkit.inventory.ItemStack;

@Service
public class BukkitEntityMapper
extends EntityMapper {
    public static boolean HAS_MOB_INTERFACE = Reflect.has("org.bukkit.entity.Mob");

    @Override
    protected <T extends EntityBasic> Optional<T> wrapEntity0(Object entity) {
        if (!(entity instanceof Entity)) {
            return Optional.empty();
        }
        if (entity instanceof Player) {
            return Optional.of(new BukkitEntityPlayer((Player)entity));
        }
        if (entity instanceof HumanEntity) {
            return Optional.of(new BukkitEntityHuman((HumanEntity)entity));
        }
        if (HAS_MOB_INTERFACE ? entity instanceof Mob : entity instanceof Slime || entity instanceof Creature) {
            return Optional.of(new BukkitEntityPathfindingMob((LivingEntity)entity));
        }
        if (entity instanceof LivingEntity) {
            return Optional.of(new BukkitEntityLiving((LivingEntity)entity));
        }
        if (entity instanceof Firework) {
            return Optional.of(new BukkitEntityFirework((Firework)entity));
        }
        if (entity instanceof Projectile) {
            return Optional.of(new BukkitEntityProjectile((Projectile)entity));
        }
        if (entity instanceof org.bukkit.entity.Item) {
            return Optional.of(new BukkitEntityItem((org.bukkit.entity.Item)entity));
        }
        if (entity instanceof LightningStrike) {
            return Optional.of(new BukkitEntityLightning((LightningStrike)entity));
        }
        if (entity instanceof ExperienceOrb) {
            return Optional.of(new BukkitEntityExperience((ExperienceOrb)entity));
        }
        return Optional.of(new BukkitEntityBasic((Entity)entity));
    }

    @Override
    public <T extends EntityBasic> Optional<T> spawn0(EntityTypeHolder entityType, LocationHolder locationHolder) {
        return entityType.asOptional(EntityType.class).flatMap(entityType1 -> {
            Location bukkitLoc = locationHolder.as(Location.class);
            World world = bukkitLoc.getWorld();
            if (world != null) {
                Entity entity = world.spawnEntity(bukkitLoc, entityType1);
                return this.wrapEntity0(entity);
            }
            return Optional.empty();
        });
    }

    @Override
    public Optional<EntityItem> dropItem0(Item item, LocationHolder locationHolder) {
        Location bukkitLoc = locationHolder.as(Location.class);
        org.bukkit.entity.Item itemEntity = bukkitLoc.getWorld().dropItem(bukkitLoc, item.as(ItemStack.class));
        return Optional.of(new BukkitEntityItem(itemEntity));
    }

    @Override
    public Optional<EntityExperience> dropExperience0(int experience, LocationHolder locationHolder) {
        Location bukkitLoc = locationHolder.as(Location.class);
        ExperienceOrb orb = (ExperienceOrb)bukkitLoc.getWorld().spawnEntity(bukkitLoc, EntityType.EXPERIENCE_ORB);
        orb.setExperience(experience);
        return Optional.of(new BukkitEntityExperience(orb));
    }

    @Override
    public Optional<EntityLightning> strikeLightning0(LocationHolder locationHolder) {
        Location bukkitLoc = locationHolder.as(Location.class);
        LightningStrike lightning = bukkitLoc.getWorld().strikeLightning(bukkitLoc);
        return Optional.of(new BukkitEntityLightning(lightning));
    }

    @Override
    public int getNewEntityId0() {
        Object entityCount = Reflect.getField(EntityAccessor.getFieldField_70152_a());
        if (entityCount != null) {
            if (entityCount instanceof AtomicInteger) {
                return ((AtomicInteger)entityCount).incrementAndGet();
            }
            int newCount = (Integer)entityCount + 1;
            Reflect.setField(EntityAccessor.getFieldField_70152_a(), newCount);
            return newCount;
        }
        Object entityCounter = Reflect.getField(EntityAccessor.getFieldENTITY_COUNTER());
        if (entityCounter instanceof AtomicInteger) {
            return ((AtomicInteger)entityCounter).incrementAndGet();
        }
        throw new UnsupportedOperationException("Can't obtain new Entity id");
    }

    @Override
    public CompletableFuture<Integer> getNewEntityIdSynchronously0() {
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        if (Server.isServerThread()) {
            future.complete(BukkitEntityMapper.getNewEntityId());
        } else {
            Server.runSynchronously(() -> future.complete(BukkitEntityMapper.getNewEntityId()));
        }
        future.exceptionally(ex -> {
            ex.printStackTrace();
            return null;
        });
        return future;
    }
}

