/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.entity;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.format.TextColor;
import io.github.pronze.lib.kyori.adventure.util.RGBLike;
import io.github.pronze.lib.screaminglib.block.BlockTypeHolder;
import io.github.pronze.lib.screaminglib.bukkit.item.BukkitItem;
import io.github.pronze.lib.screaminglib.bukkit.utils.nms.Version;
import io.github.pronze.lib.screaminglib.entity.EntityBasic;
import io.github.pronze.lib.screaminglib.entity.EntityMapper;
import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.item.ItemTypeHolder;
import io.github.pronze.lib.screaminglib.utils.AdventureHelper;
import io.github.pronze.lib.screaminglib.utils.Wrapper;
import io.github.pronze.lib.screaminglib.utils.math.Vector3D;
import io.github.pronze.lib.screaminglib.utils.math.Vector3Df;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import io.github.pronze.lib.screaminglib.world.LocationMapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Rotation;
import org.bukkit.TreeSpecies;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.AbstractSkeleton;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Breedable;
import org.bukkit.entity.Cat;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Evoker;
import org.bukkit.entity.EvokerFangs;
import org.bukkit.entity.Explosive;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Fox;
import org.bukkit.entity.GlowSquid;
import org.bukkit.entity.Goat;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.Hoglin;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Husk;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.PiglinAbstract;
import org.bukkit.entity.PufferFish;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Raider;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.SizedFireball;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.Spellcaster;
import org.bukkit.entity.Steerable;
import org.bukkit.entity.Strider;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Villager;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.entity.minecart.PoweredMinecart;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Colorable;
import org.bukkit.material.MaterialData;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitEntityMetadataMapper {
    private static final Map<Class<? extends Entity>, Map<String, BukkitMetadata<?, ?>>> METADATA = new HashMap();

    public static boolean has(Entity entity, String metadata) {
        String finalMetadata = metadata.toLowerCase();
        return METADATA.entrySet().stream().anyMatch(classMapEntry -> ((Class)classMapEntry.getKey()).isInstance(entity) && ((Map)classMapEntry.getValue()).containsKey(finalMetadata));
    }

    public static void set(Entity entity, String metadata, Object value) {
        Optional opt;
        String finalMetadata = metadata.toLowerCase();
        BukkitMetadata bukkitMetadata = METADATA.entrySet().stream().filter(classMapEntry -> ((Class)classMapEntry.getKey()).isInstance(entity) && ((Map)classMapEntry.getValue()).containsKey(finalMetadata)).map(classMapEntry -> (BukkitMetadata)((Map)classMapEntry.getValue()).get(finalMetadata)).findFirst().orElseThrow();
        if (bukkitMetadata.setter == null) {
            throw new UnsupportedOperationException("Can't change an immutable metadata value!");
        }
        if (value instanceof Wrapper && (opt = ((Wrapper)value).asOptional(bukkitMetadata.valueClass)).isPresent()) {
            value = opt.get();
        }
        if (bukkitMetadata.valueClass == EulerAngle.class) {
            if (value instanceof Vector3D) {
                value = new EulerAngle(((Vector3D)value).getX(), ((Vector3D)value).getY(), ((Vector3D)value).getZ());
            } else if (value instanceof Vector3Df) {
                value = new EulerAngle((double)((Vector3Df)value).getX(), (double)((Vector3Df)value).getY(), (double)((Vector3Df)value).getZ());
            }
        } else if (bukkitMetadata.valueClass == Vector.class) {
            if (value instanceof Vector3D) {
                value = new Vector(((Vector3D)value).getX(), ((Vector3D)value).getY(), ((Vector3D)value).getZ());
            } else if (value instanceof Vector3Df) {
                value = new Vector(((Vector3Df)value).getX(), ((Vector3Df)value).getY(), ((Vector3Df)value).getZ());
            }
        } else if (bukkitMetadata.valueClass == Color.class) {
            if (value instanceof RGBLike) {
                value = Color.fromRGB((int)((RGBLike)value).red(), (int)((RGBLike)value).green(), (int)((RGBLike)value).blue());
            }
        } else if (bukkitMetadata.valueClass == DyeColor.class) {
            if (value instanceof RGBLike) {
                value = DyeColor.getByColor((Color)Color.fromRGB((int)((RGBLike)value).red(), (int)((RGBLike)value).green(), (int)((RGBLike)value).blue()));
            } else if (value instanceof Number) {
                value = DyeColor.getByWoolData((byte)((Number)value).byteValue());
            }
        } else if (bukkitMetadata.valueClass.isEnum() && value instanceof String) {
            String finalValue = (String)value;
            value = Arrays.stream(bukkitMetadata.valueClass.getEnumConstants()).filter(o -> finalValue.equalsIgnoreCase((String)Reflect.fastInvoke(o, "name"))).findFirst().orElse(null);
        } else if (value instanceof Component) {
            value = AdventureHelper.toLegacyNullableResult((Component)value);
        }
        if (value != null) {
            if (bukkitMetadata.valueClass == Boolean.class) {
                if (!(value instanceof Boolean)) {
                    value = Boolean.parseBoolean(value.toString());
                }
            } else if (bukkitMetadata.valueClass == Integer.class) {
                if (value instanceof Number) {
                    value = ((Number)value).intValue();
                } else {
                    try {
                        value = Integer.parseInt(value.toString());
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else if (bukkitMetadata.valueClass == Long.class) {
                if (value instanceof Number) {
                    value = ((Number)value).longValue();
                } else {
                    try {
                        value = Long.parseLong(value.toString());
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else if (bukkitMetadata.valueClass == Float.class) {
                if (value instanceof Number) {
                    value = Float.valueOf(((Number)value).floatValue());
                } else {
                    try {
                        value = Float.valueOf(Float.parseFloat(value.toString()));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else if (bukkitMetadata.valueClass == Double.class) {
                if (value instanceof Number) {
                    value = ((Number)value).doubleValue();
                } else {
                    try {
                        value = Double.parseDouble(value.toString());
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else if (bukkitMetadata.valueClass == Byte.class) {
                if (value instanceof Number) {
                    value = ((Number)value).byteValue();
                } else {
                    try {
                        value = Byte.parseByte(value.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        if (value == null || bukkitMetadata.valueClass.isInstance(value)) {
            bukkitMetadata.setter.accept(entity, value);
        }
    }

    public static <T> T get(Entity entity, String metadata, Class<T> valueClass) {
        String finalMetadata = metadata.toLowerCase();
        BukkitMetadata bukkitMetadata = METADATA.entrySet().stream().filter(classMapEntry -> ((Class)classMapEntry.getKey()).isInstance(entity) && ((Map)classMapEntry.getValue()).containsKey(finalMetadata)).map(classMapEntry -> (BukkitMetadata)((Map)classMapEntry.getValue()).get(finalMetadata)).findFirst().orElseThrow();
        Object value = bukkitMetadata.getter.apply(entity);
        if (valueClass.isInstance(value)) {
            return (T)value;
        }
        if (valueClass == BlockTypeHolder.class) {
            return (T)BlockTypeHolder.of(value);
        }
        if (valueClass == ItemTypeHolder.class) {
            return (T)ItemTypeHolder.of(value);
        }
        if (EntityBasic.class.isAssignableFrom(valueClass) && value instanceof Entity) {
            return EntityMapper.wrapEntity(value).orElseThrow();
        }
        if (value instanceof ItemStack && valueClass == Item.class) {
            return (T)new BukkitItem((ItemStack)value);
        }
        if (valueClass == LocationHolder.class) {
            if (value instanceof Location) {
                return (T)LocationMapper.wrapLocation(value);
            }
        } else {
            if (valueClass == Component.class) {
                return (T)AdventureHelper.toComponentNullableResult(value.toString());
            }
            if (valueClass == String.class) {
                if (value.getClass().isEnum()) {
                    return (T)Reflect.fastInvoke(value, "name");
                }
                return (T)value.toString();
            }
            if (valueClass == Vector3D.class) {
                if (value instanceof EulerAngle) {
                    return (T)new Vector3D(((EulerAngle)value).getX(), ((EulerAngle)value).getY(), ((EulerAngle)value).getZ());
                }
                if (value instanceof Vector) {
                    return (T)new Vector3D(((Vector)value).getX(), ((Vector)value).getY(), ((Vector)value).getZ());
                }
            } else if (valueClass == Vector3Df.class) {
                if (value instanceof EulerAngle) {
                    return (T)new Vector3Df((float)((EulerAngle)value).getX(), (float)((EulerAngle)value).getY(), (float)((EulerAngle)value).getZ());
                }
                if (value instanceof Vector) {
                    return (T)new Vector3Df((float)((Vector)value).getX(), (float)((Vector)value).getY(), (float)((Vector)value).getZ());
                }
            } else if (valueClass == RGBLike.class) {
                if (value instanceof Color) {
                    return (T)TextColor.color(((Color)value).getRed(), ((Color)value).getGreen(), ((Color)value).getBlue());
                }
                if (value instanceof DyeColor) {
                    return (T)TextColor.color(((DyeColor)value).getColor().getRed(), ((DyeColor)value).getColor().getGreen(), ((DyeColor)value).getColor().getBlue());
                }
            } else {
                if (valueClass == Boolean.class) {
                    if (value instanceof Boolean) {
                        return (T)value;
                    }
                    return (T)Boolean.valueOf(value.toString());
                }
                if (valueClass == Integer.class) {
                    if (value instanceof Number) {
                        return (T)Integer.valueOf(((Number)value).intValue());
                    }
                    try {
                        return (T)Integer.valueOf(value.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                } else if (valueClass == Long.class) {
                    if (value instanceof Number) {
                        return (T)Long.valueOf(((Number)value).longValue());
                    }
                    try {
                        return (T)Long.valueOf(value.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                } else if (valueClass == Byte.class) {
                    if (value instanceof Number) {
                        return (T)Byte.valueOf(((Number)value).byteValue());
                    }
                    if (value instanceof DyeColor) {
                        return (T)Byte.valueOf(((DyeColor)value).getWoolData());
                    }
                    try {
                        return (T)Byte.valueOf(value.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                } else if (valueClass == Double.class) {
                    if (value instanceof Number) {
                        return (T)Double.valueOf(((Number)value).doubleValue());
                    }
                    try {
                        return (T)Double.valueOf(value.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                } else if (valueClass == Float.class) {
                    if (value instanceof Number) {
                        return (T)Float.valueOf(((Number)value).floatValue());
                    }
                    try {
                        return (T)Float.valueOf(value.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        throw new UnsupportedOperationException("Can't convert metadata " + metadata + " of " + entity + " to " + valueClass.getName());
    }

    static {
        boolean breedableExist = Reflect.has("org.bukkit.entity.Breedable");
        boolean steerableExist = Reflect.has("org.bukkit.entity.Steerable");
        boolean spellcasterExist = Reflect.has("org.bukkit.entity.Spellcaster");
        if (Reflect.has("org.bukkit.entity.AbstractHorse")) {
            Builder.begin(AbstractHorse.class).map("domestication", Integer.class, AbstractHorse::getDomestication, AbstractHorse::setDomestication).map("max_domestication", Integer.class, AbstractHorse::getMaxDomestication, AbstractHorse::setMaxDomestication).map("jump_strength", Double.class, AbstractHorse::getJumpStrength, AbstractHorse::setJumpStrength);
        }
        Builder.begin(Ageable.class).map("is_baby", "data_baby_id", Boolean.class, ageable -> !ageable.isAdult(), (ageable, aBoolean) -> {
            if (aBoolean.booleanValue()) {
                ageable.setBaby();
            } else {
                ageable.setAdult();
            }
        }).map("age", Integer.class, Ageable::getAge, Ageable::setAge).when(!breedableExist, b -> b.map("breed", Boolean.class, Ageable::canBreed, Ageable::setBreed).map("ageLock", Boolean.class, Ageable::getAgeLock, Ageable::setAgeLock));
        Builder.begin(AreaEffectCloud.class).map("radius", "data_radius", Float.class, AreaEffectCloud::getRadius, AreaEffectCloud::setRadius).map("color", "data_color", Color.class, AreaEffectCloud::getColor, AreaEffectCloud::setColor);
        Builder.begin(ArmorStand.class).map("small", Boolean.class, ArmorStand::isSmall, ArmorStand::setSmall).map("arms", Boolean.class, ArmorStand::hasArms, ArmorStand::setArms).map("base_plate", Boolean.class, ArmorStand::hasBasePlate, ArmorStand::setBasePlate).map("marker", Boolean.class, ArmorStand::isMarker, ArmorStand::setMarker).map("head_pose", "data_head_pose", EulerAngle.class, ArmorStand::getHeadPose, ArmorStand::setHeadPose).map("body_pose", "data_body_pose", EulerAngle.class, ArmorStand::getBodyPose, ArmorStand::setBodyPose).map("left_arm_pose", "data_left_arm_pose", EulerAngle.class, ArmorStand::getLeftArmPose, ArmorStand::setLeftArmPose).map("right_arm_pose", "data_right_arm_pose", EulerAngle.class, ArmorStand::getRightArmPose, ArmorStand::setRightArmPose).map("left_leg_pose", "data_left_leg_pose", EulerAngle.class, ArmorStand::getLeftLegPose, ArmorStand::setLeftLegPose).map("right_leg_pose", "data_right_leg_pose", EulerAngle.class, ArmorStand::getRightLegPose, ArmorStand::setRightLegPose);
        Builder.begin(Arrow.class).map("effect_color", "id_effect_color", Color.class, Arrow::getColor, Arrow::setColor);
        if (Reflect.has("org.bukkit.entity.Axolotl")) {
            Builder.begin(Axolotl.class).map("variant", "data_variant", Axolotl.Variant.class, Axolotl::getVariant, Axolotl::setVariant).map("playing_dead", "data_playing_dead", Boolean.class, Axolotl::isPlayingDead, Axolotl::setPlayingDead);
        }
        Builder.begin(Bat.class).map("awake", Boolean.class, Bat::isAwake, Bat::setAwake).map("is_hanging", Boolean.class, bat -> !bat.isAwake(), (bat, aBoolean) -> bat.setAwake(aBoolean == false)).map("flags", "data_id_flags", Byte.class, bat -> (byte)(!bat.isAwake() ? 1 : 0), (bat, aByte) -> bat.setAwake((aByte & 1) == 1));
        if (Reflect.has("org.bukkit.entity.Bee")) {
            Builder.begin(Bee.class).map("hive", Location.class, Bee::getHive, Bee::setHive).map("flower", Location.class, Bee::getFlower, Bee::setFlower).map("has_nectar", Boolean.class, Bee::hasNectar, Bee::setHasNectar).when(() -> Reflect.hasMethod(Bee.class, "getCannotEnterHiveTicks", new Class[0]), b -> b.map("remaining_anger_time", "data_remaining_anger_time", Integer.class, Bee::getAnger, Bee::setAnger).map("cannot_enter_hive_ticks", Integer.class, Bee::getCannotEnterHiveTicks, Bee::setCannotEnterHiveTicks));
        }
        Builder.begin(Boat.class).map("wood_type", "data_id_type", TreeSpecies.class, Boat::getWoodType, Boat::setWoodType);
        if (breedableExist) {
            Builder.begin(Breedable.class).map("breed", Boolean.class, Breedable::canBreed, Breedable::setBreed).map("ageLock", Boolean.class, Breedable::getAgeLock, Breedable::setAgeLock);
        }
        if (Reflect.has("org.bukkit.entity.Cat")) {
            Builder.begin(Cat.class).map("cat_type", "data_type_id", Cat.Type.class, Cat::getCatType, Cat::setCatType).map("collar_color", "data_collar_color", DyeColor.class, Cat::getCollarColor, Cat::setCollarColor);
        }
        if (Reflect.has("org.bukkit.entity.ChestedHorse")) {
            Builder.begin(ChestedHorse.class).map("is_carrying_chest", "data_has_chat", Boolean.class, ChestedHorse::isCarryingChest, ChestedHorse::setCarryingChest);
        }
        Builder.begin(Creeper.class).map("powered", "data_is_powered", Boolean.class, Creeper::isPowered, Creeper::setPowered).when(Reflect.hasMethod(Creeper.class, "getMaxFuseTicks", new Class[0]), b -> b.map("max_fuse_ticks", Integer.class, Creeper::getMaxFuseTicks, Creeper::setMaxFuseTicks).map("explosion_radius", Integer.class, Creeper::getExplosionRadius, Creeper::setExplosionRadius).when(Reflect.hasMethod(Creeper.class, "getFuseTicks", new Class[0]), b2 -> b2.map("fuse_ticks", Integer.class, Creeper::getFuseTicks, Creeper::setFuseTicks)));
        Builder.begin(EnderCrystal.class).map("showing_bottom", "data_show_bottom", Boolean.class, EnderCrystal::isShowingBottom, EnderCrystal::setShowingBottom).map("beam_target", "data_beam_target", Location.class, EnderCrystal::getBeamTarget, EnderCrystal::setBeamTarget);
        Builder.begin(EnderDragon.class).map("phase", "data_phase", EnderDragon.Phase.class, EnderDragon::getPhase, EnderDragon::setPhase);
        Builder.begin(Enderman.class).whenNot(1, 13, b -> b.map("carried_block", MaterialData.class, Enderman::getCarriedMaterial, Enderman::setCarriedMaterial)).when(1, 13, b -> b.map("carried_block", BlockData.class, Enderman::getCarriedBlock, Enderman::setCarriedBlock));
        if (!spellcasterExist) {
            Builder.begin(Evoker.class).map("spell", Evoker.Spell.class, Evoker::getCurrentSpell, Evoker::setCurrentSpell);
        }
        if (Reflect.has("org.bukkit.entity.EvokerFangs")) {
            Builder.begin(EvokerFangs.class).map("owner", LivingEntity.class, EvokerFangs::getOwner, EvokerFangs::setOwner);
        }
        Builder.begin(Explosive.class).map("is_incendiary", Boolean.class, Explosive::isIncendiary, Explosive::setIsIncendiary).map("yield", Float.class, Explosive::getYield, Explosive::setYield);
        Builder.begin(FallingBlock.class).map("drop_item", Boolean.class, FallingBlock::getDropItem, FallingBlock::setDropItem).map("can_hurt_entities", Boolean.class, FallingBlock::canHurtEntities, FallingBlock::setHurtEntities).when(1, 13, b -> b.map("block_data", BlockData.class, FallingBlock::getBlockData, null)).whenNot(1, 13, b -> b.map("block_data", Material.class, FallingBlock::getMaterial, null));
        Builder.begin(Fireball.class).map("direction", Vector.class, Fireball::getDirection, Fireball::setDirection);
        if (Reflect.has("org.bukkit.entity.Fox")) {
            Builder.begin(Fox.class).map("fox_type", Fox.Type.class, Fox::getFoxType, Fox::setFoxType).map("is_crouching", Boolean.class, Fox::isCrouching, Fox::setCrouching).map("is_sleeping", Boolean.class, LivingEntity::isSleeping, Fox::setSleeping).when(Reflect.hasMethod(Fox.class, "getFirstTrustedPlayer", new Class[0]), b -> b.map("first_trusted_player", UUID.class, fox -> {
                AnimalTamer trusted = fox.getFirstTrustedPlayer();
                if (trusted != null) {
                    return trusted.getUniqueId();
                }
                return null;
            }, (fox, uuid) -> fox.setFirstTrustedPlayer((AnimalTamer)(uuid == null ? null : Bukkit.getOfflinePlayer((UUID)uuid)))).map("second_trusted_player", UUID.class, fox -> {
                AnimalTamer trusted = fox.getSecondTrustedPlayer();
                if (trusted != null) {
                    return trusted.getUniqueId();
                }
                return null;
            }, (fox, uuid) -> fox.setSecondTrustedPlayer((AnimalTamer)(uuid == null ? null : Bukkit.getOfflinePlayer((UUID)uuid)))));
        }
        if (Reflect.has("org.bukkit.entity.GlowSquid")) {
            Builder.begin(GlowSquid.class).map("dark_ticks_remaining", "data_dark_ticks_remaining", Integer.class, GlowSquid::getDarkTicksRemaining, GlowSquid::setDarkTicksRemaining);
        }
        if (Reflect.has("org.bukkit.entity.Goat")) {
            Builder.begin(Goat.class).map("screaming", "data_is_screaming_goat", Boolean.class, Goat::isScreaming, Goat::setScreaming);
        }
        Builder.begin(Guardian.class).map("has_laser", Boolean.class, Guardian::hasLaser, Guardian::setLaser);
        if (Reflect.has("org.bukkit.entity.Hoglin")) {
            Builder.begin(Hoglin.class).map("is_immune_to_zombification", Boolean.class, Hoglin::isImmuneToZombification, Hoglin::setImmuneToZombification).map("is_able_to_be_hunted", Boolean.class, Hoglin::isAbleToBeHunted, Hoglin::setIsAbleToBeHunted).when(Reflect.hasMethod(Hoglin.class, "isConverting", new Class[0]), b -> b.map("is_converting", Boolean.class, Hoglin::isConverting, null).map("conversion_time", Integer.class, Hoglin::getConversionTime, Hoglin::setConversionTime));
        }
        Builder.begin(Horse.class).map("color", Horse.Color.class, Horse::getColor, Horse::setColor).map("style", Horse.Style.class, Horse::getStyle, Horse::setStyle).whenNot(1, 11, b -> b.map("variant", Horse.Variant.class, AbstractHorse::getVariant, AbstractHorse::setVariant).map("is_carrying_chest", Boolean.class, Horse::isCarryingChest, Horse::setCarryingChest).map("domestication", Integer.class, AbstractHorse::getDomestication, AbstractHorse::setDomestication).map("max_domestication", Integer.class, AbstractHorse::getMaxDomestication, AbstractHorse::setMaxDomestication).map("jump_strength", Double.class, AbstractHorse::getJumpStrength, AbstractHorse::setJumpStrength));
        if (Reflect.has("org.bukkit.entity.Husk")) {
            Builder.begin(Husk.class).when(Reflect.hasMethod(Husk.class, "isConverting", new Class[0]), b -> b.map("is_converting", Boolean.class, Husk::isConverting, null).map("conversion_time", Integer.class, Husk::getConversionTime, Husk::setConversionTime));
        }
        Builder.begin(IronGolem.class).map("is_player_created", Boolean.class, IronGolem::isPlayerCreated, IronGolem::setPlayerCreated);
        Builder.begin(ItemFrame.class).map("item", ItemStack.class, ItemFrame::getItem, ItemFrame::setItem).map("rotation", Rotation.class, ItemFrame::getRotation, ItemFrame::setRotation).when(Reflect.hasMethod(ItemFrame.class, "isVisible", new Class[0]), b -> b.map("visible", Boolean.class, ItemFrame::isVisible, ItemFrame::setVisible).map("fixed", Boolean.class, ItemFrame::isFixed, ItemFrame::setFixed)).when(Reflect.hasMethod(ItemFrame.class, "getItemDropChance", new Class[0]), b -> b.map("item_drop_chance", Float.class, ItemFrame::getItemDropChance, ItemFrame::setItemDropChance));
        if (Reflect.has("org.bukkit.entity.Llama")) {
            Builder.begin(Llama.class).map("color", Llama.Color.class, Llama::getColor, Llama::setColor).map("strength", Integer.class, Llama::getStrength, Llama::setStrength);
        }
        Builder.begin(Minecart.class).map("damage", Double.class, Minecart::getDamage, Minecart::setDamage).map("max_speed", Double.class, Minecart::getMaxSpeed, Minecart::setMaxSpeed).map("is_slow_when_empty", Boolean.class, Minecart::isSlowWhenEmpty, Minecart::setSlowWhenEmpty).map("flying_velocity_mod", Vector.class, Minecart::getFlyingVelocityMod, Minecart::setFlyingVelocityMod).map("derailed_velocity_mod", Vector.class, Minecart::getDerailedVelocityMod, Minecart::setDerailedVelocityMod).map("display_block_offset", Integer.class, Minecart::getDisplayBlockOffset, Minecart::setDisplayBlockOffset).whenNot(1, 13, b -> b.map("display_block_data", MaterialData.class, Minecart::getDisplayBlock, Minecart::setDisplayBlock)).when(1, 13, b -> b.map("display_block_data", BlockData.class, Minecart::getDisplayBlockData, Minecart::setDisplayBlockData));
        Builder.begin(CommandMinecart.class).map("command", String.class, CommandMinecart::getCommand, CommandMinecart::setCommand);
        Builder.begin(HopperMinecart.class).map("is_enabled", Boolean.class, HopperMinecart::isEnabled, HopperMinecart::setEnabled);
        if (Reflect.hasMethod(PoweredMinecart.class, "getFuel", new Class[0])) {
            Builder.begin(PoweredMinecart.class).map("fuel", Integer.class, PoweredMinecart::getFuel, PoweredMinecart::setFuel);
        }
        if (Reflect.hasMethod(MushroomCow.class, "getVariant", new Class[0])) {
            Builder.begin(MushroomCow.class).map("variant", "data_type", MushroomCow.Variant.class, MushroomCow::getVariant, MushroomCow::setVariant);
        }
        Builder.begin(Ocelot.class).whenNot(1, 14, b -> b.map("cat_type", Ocelot.Type.class, Ocelot::getCatType, Ocelot::setCatType)).when(Reflect.hasMethod(Ocelot.class, "isTrusting", new Class[0]), b -> b.map("is_trusting", Boolean.class, Ocelot::isTrusting, Ocelot::setTrusting));
        Builder.begin(Painting.class).map("art", Art.class, Painting::getArt, Painting::setArt);
        if (Reflect.has("org.bukkit.entity.Panda")) {
            Builder.begin(Panda.class).map("main_gene", "main_gene_id", Panda.Gene.class, Panda::getMainGene, Panda::setMainGene).map("hidden_gene", "hidden_gene_id", Panda.Gene.class, Panda::getHiddenGene, Panda::setHiddenGene);
        }
        if (Reflect.has("org.bukkit.entity.Parrot")) {
            Builder.begin(Parrot.class).map("variant", "data_variant_id", Parrot.Variant.class, Parrot::getVariant, Parrot::setVariant);
        }
        if (Reflect.has("org.bukkit.entity.Phantom")) {
            Builder.begin(Phantom.class).map("size", "id_size", Integer.class, Phantom::getSize, Phantom::setSize);
        }
        if (!steerableExist) {
            Builder.begin(Pig.class).map("has_saddle", Boolean.class, Steerable::hasSaddle, Steerable::setSaddle);
        }
        if (Reflect.has("org.bukkit.entity.Piglin")) {
            Builder.begin(Piglin.class).map("is_able_to_hunt", Boolean.class, Piglin::isAbleToHunt, Piglin::setIsAbleToHunt).whenNot(breedableExist, b -> b.map("is_baby", "data_baby_id", Boolean.class, PiglinAbstract::isBaby, PiglinAbstract::setBaby)).whenNot(1, 16, 2, b -> b.map("is_immune_to_zombification", Boolean.class, PiglinAbstract::isImmuneToZombification, PiglinAbstract::setImmuneToZombification).when(Reflect.hasMethod(Piglin.class, "isConverting", new Class[0]), b2 -> b2.map("is_converting", Boolean.class, PiglinAbstract::isConverting, null).map("conversion_time", Integer.class, PiglinAbstract::getConversionTime, PiglinAbstract::setConversionTime)));
        }
        if (Reflect.has("org.bukkit.entity.PiglinAbstract")) {
            Builder.begin(PiglinAbstract.class).whenNot(breedableExist, b -> b.map("is_baby", "data_baby_id", Boolean.class, PiglinAbstract::isBaby, PiglinAbstract::setBaby)).map("is_immune_to_zombification", Boolean.class, PiglinAbstract::isImmuneToZombification, PiglinAbstract::setImmuneToZombification).when(Reflect.hasMethod(Piglin.class, "isConverting", new Class[0]), b2 -> b2.map("is_converting", Boolean.class, PiglinAbstract::isConverting, null).map("conversion_time", Integer.class, PiglinAbstract::getConversionTime, PiglinAbstract::setConversionTime));
        }
        Builder.begin(PigZombie.class).map("anger_level", Integer.class, PigZombie::getAnger, PigZombie::setAnger).map("is_angry", Boolean.class, PigZombie::isAngry, PigZombie::setAngry);
        if (Reflect.has("org.bukkit.entity.PufferFish")) {
            Builder.begin(PufferFish.class).map("puff_state", Integer.class, PufferFish::getPuffState, PufferFish::setPuffState);
        }
        Builder.begin(Rabbit.class).map("rabbit_type", "data_type_id", Rabbit.Type.class, Rabbit::getRabbitType, Rabbit::setRabbitType);
        if (Reflect.has("org.bukkit.entity.Raider")) {
            Builder.begin(Raider.class).map("patrol_target", Location.class, raider -> {
                Block target = raider.getPatrolTarget();
                if (target != null) {
                    return raider.getPatrolTarget().getLocation();
                }
                return null;
            }, (raider, location) -> raider.setPatrolTarget(location == null ? null : location.getBlock())).map("is_patrol_leader", Boolean.class, Raider::isPatrolLeader, Raider::setPatrolLeader).when(Reflect.hasMethod(Raider.class, "isCanJoinRaid", new Class[0]), b -> b.map("can_join_raid", Boolean.class, Raider::isCanJoinRaid, Raider::setCanJoinRaid));
        }
        Builder.begin(Sheep.class).map("color", DyeColor.class, Colorable::getColor, Colorable::setColor).map("sheared", Boolean.class, Sheep::isSheared, Sheep::setSheared);
        Builder.begin(ShulkerBullet.class).map("target", Entity.class, ShulkerBullet::getTarget, ShulkerBullet::setTarget);
        if (Reflect.has("org.bukkit.entity.SizedFireball")) {
            Builder.begin(SizedFireball.class).map("display_item", ItemStack.class, SizedFireball::getDisplayItem, SizedFireball::setDisplayItem);
        }
        Builder.begin(Skeleton.class).whenNot(1, 11, b -> b.map("skeleton_type", Skeleton.SkeletonType.class, AbstractSkeleton::getSkeletonType, AbstractSkeleton::setSkeletonType)).when(Reflect.hasMethod(Skeleton.class, "isConverting", new Class[0]), b -> b.map("is_converting", Boolean.class, Skeleton::isConverting, null).map("conversion_time", Integer.class, Skeleton::getConversionTime, Skeleton::setConversionTime));
        Builder.begin(Slime.class).map("size", "id_size", Integer.class, Slime::getSize, Slime::setSize);
        if (Reflect.hasMethod(Snowman.class, "isDerp", new Class[0])) {
            Builder.begin(Snowman.class).map("derp", Boolean.class, Snowman::isDerp, Snowman::setDerp);
        }
        Builder.begin(SpectralArrow.class).map("glowing_ticks", Integer.class, SpectralArrow::getGlowingTicks, SpectralArrow::setGlowingTicks);
        if (spellcasterExist) {
            Builder.begin(Spellcaster.class).map("spell", Spellcaster.Spell.class, Spellcaster::getSpell, Spellcaster::setSpell);
        }
        if (steerableExist) {
            Builder.begin(Steerable.class).map("has_saddle", Boolean.class, Steerable::hasSaddle, Steerable::setSaddle).map("boost_ticks", Integer.class, Steerable::getBoostTicks, Steerable::setBoostTicks).map("current_boost_ticks", Integer.class, Steerable::getCurrentBoostTicks, Steerable::setCurrentBoostTicks).map("steer_material", Material.class, Steerable::getSteerMaterial, null);
        }
        if (Reflect.has("org.bukkit.entity.Strider")) {
            Builder.begin(Strider.class).map("shivering", "data_suffocating", Boolean.class, Strider::isShivering, Strider::setShivering);
        }
        Builder.begin(Tameable.class).map("is_tamed", Boolean.class, Tameable::isTamed, Tameable::setTamed).map("owner", UUID.class, animal -> {
            AnimalTamer trusted = animal.getOwner();
            if (trusted != null) {
                return trusted.getUniqueId();
            }
            return null;
        }, (animal, uuid) -> animal.setOwner((AnimalTamer)(uuid == null ? null : Bukkit.getOfflinePlayer((UUID)uuid))));
        boolean ss = Reflect.hasMethod(TNTPrimed.class, "setSource", new Class[0]);
        Builder.begin(TNTPrimed.class).map("fuse_ticks", "data_fuse_id", Integer.class, TNTPrimed::getFuseTicks, TNTPrimed::setFuseTicks).whenNot(ss, b -> b.map("source", Entity.class, TNTPrimed::getSource, null)).when(ss, b -> b.map("source", Entity.class, TNTPrimed::getSource, TNTPrimed::setSource));
        if (Reflect.has("org.bukkit.entity.TropicalFish")) {
            Builder.begin(TropicalFish.class).map("pattern_color", DyeColor.class, TropicalFish::getPatternColor, TropicalFish::setPatternColor).map("body_color", DyeColor.class, TropicalFish::getBodyColor, TropicalFish::setBodyColor).map("pattern", TropicalFish.Pattern.class, TropicalFish::getPattern, TropicalFish::setPattern);
        }
        if (Reflect.has("org.bukkit.entity.Vex") && Reflect.hasMethod("org.bukkit.entity.Vex", "isCharging", new Class[0])) {
            Builder.begin(Vex.class).map("is_charging", "data_is_charging", Boolean.class, Vex::isCharging, Vex::setCharging);
        }
        Builder.begin(Villager.class).map("villager_profession", Villager.Profession.class, Villager::getProfession, Villager::setProfession).when(1, 14, b -> b.map("villager_type", Villager.Type.class, Villager::getVillagerType, Villager::setVillagerType).map("villager_level", Integer.class, Villager::getVillagerLevel, Villager::setVillagerLevel).map("villager_experience", Integer.class, Villager::getVillagerExperience, Villager::setVillagerExperience));
        if (Reflect.has("org.bukkit.entity.WanderingTrader") && Reflect.hasMethod("org.bukkit.entity.WanderingTrader", "isCharging", new Class[0])) {
            Builder.begin(WanderingTrader.class).map("despawn_delay", Integer.class, WanderingTrader::getDespawnDelay, WanderingTrader::setDespawnDelay);
        }
        Builder.begin(WitherSkull.class).map("is_charged", "data_dangerous", Boolean.class, WitherSkull::isCharged, WitherSkull::setCharged);
        Builder.begin(Wolf.class).map("is_angry", Boolean.class, Wolf::isAngry, Wolf::setAngry).map("collar_color", "data_collar_color", DyeColor.class, Wolf::getCollarColor, Wolf::setCollarColor);
        Builder.begin(Zombie.class).whenNot(breedableExist, b -> b.map("is_baby", "data_baby_id", Boolean.class, Zombie::isBaby, Zombie::setBaby)).whenNot(1, 11, b -> b.map("is_villager", Boolean.class, Zombie::isVillager, Zombie::setVillager).map("villager_profession", Villager.Profession.class, Zombie::getVillagerProfession, Zombie::setVillagerProfession)).when(Reflect.hasMethod(Zombie.class, "isConverting", new Class[0]), b -> b.map("is_converting", Boolean.class, Zombie::isConverting, null).map("conversion_time", Integer.class, Zombie::getConversionTime, Zombie::setConversionTime));
        if (Reflect.has("org.bukkit.entity.ZombieVillager")) {
            Builder.begin(ZombieVillager.class).map("villager_profession", Villager.Profession.class, ZombieVillager::getVillagerProfession, ZombieVillager::setVillagerProfession).when(Reflect.hasMethod(ZombieVillager.class, "isConverting", new Class[0]), b -> b.map("is_converting", Boolean.class, Zombie::isConverting, null).map("conversion_time", Integer.class, Zombie::getConversionTime, Zombie::setConversionTime)).when(Reflect.hasMethod(ZombieVillager.class, "getConversionPlayer", new Class[0]), b -> b.map("conversion_player", UUID.class, zombie -> {
                OfflinePlayer player = zombie.getConversionPlayer();
                if (player != null) {
                    return player.getUniqueId();
                }
                return null;
            }, (zombieVillager, uuid) -> zombieVillager.setConversionPlayer(uuid == null ? null : Bukkit.getOfflinePlayer((UUID)uuid)))).when(Reflect.hasMethod(ZombieVillager.class, "getVillagerType", new Class[0]), b -> b.map("villager_type", Villager.Type.class, ZombieVillager::getVillagerType, ZombieVillager::setVillagerType));
        }
    }

    public static class BukkitMetadata<E extends Entity, V> {
        private final Class<V> valueClass;
        @NotNull
        private final Function<E, V> getter;
        @Nullable
        private final BiConsumer<E, V> setter;

        public BukkitMetadata(Class<V> valueClass, @NotNull Function<E, V> getter, @Nullable BiConsumer<E, V> setter) {
            if (getter == null) {
                throw new NullPointerException("getter is marked non-null but is null");
            }
            this.valueClass = valueClass;
            this.getter = getter;
            this.setter = setter;
        }

        public Class<V> getValueClass() {
            return this.valueClass;
        }

        @NotNull
        public Function<E, V> getGetter() {
            return this.getter;
        }

        @Nullable
        public BiConsumer<E, V> getSetter() {
            return this.setter;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BukkitMetadata)) {
                return false;
            }
            BukkitMetadata other = (BukkitMetadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<V> this$valueClass = this.getValueClass();
            Class<V> other$valueClass = other.getValueClass();
            if (this$valueClass == null ? other$valueClass != null : !this$valueClass.equals(other$valueClass)) {
                return false;
            }
            Function<E, V> this$getter = this.getGetter();
            Function<E, V> other$getter = other.getGetter();
            if (this$getter == null ? other$getter != null : !this$getter.equals(other$getter)) {
                return false;
            }
            BiConsumer<E, V> this$setter = this.getSetter();
            BiConsumer<E, V> other$setter = other.getSetter();
            return !(this$setter == null ? other$setter != null : !this$setter.equals(other$setter));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BukkitMetadata;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<V> $valueClass = this.getValueClass();
            result = result * 59 + ($valueClass == null ? 43 : $valueClass.hashCode());
            Function<E, V> $getter = this.getGetter();
            result = result * 59 + ($getter == null ? 43 : $getter.hashCode());
            BiConsumer<E, V> $setter = this.getSetter();
            result = result * 59 + ($setter == null ? 43 : $setter.hashCode());
            return result;
        }

        public String toString() {
            return "BukkitEntityMetadataMapper.BukkitMetadata(valueClass=" + this.getValueClass() + ", getter=" + this.getGetter() + ", setter=" + this.getSetter() + ")";
        }
    }

    public static class Builder<E extends Entity> {
        private final Class<E> clazz;
        private boolean registered = false;
        private final Map<String, BukkitMetadata<E, ?>> metadataMap = new HashMap();

        public static <E extends Entity> Builder<E> begin(Class<E> entityClass) {
            return new Builder<E>(entityClass);
        }

        public <V> Builder<E> map(@NotNull String name, @NotNull Class<V> valueClass, @NotNull Function<E, V> getter, @Nullable BiConsumer<E, V> setter) {
            this.metadataMap.put(name.toLowerCase(), new BukkitMetadata<E, V>(valueClass, getter, setter));
            if (!this.registered) {
                METADATA.put(this.clazz, this.metadataMap);
                this.registered = true;
            }
            return this;
        }

        public <V> Builder<E> map(@NotNull String name, @Nullable String alternativeName, @NotNull Class<V> valueClass, @NotNull Function<E, V> getter, @Nullable BiConsumer<E, V> setter) {
            BukkitMetadata<E, V> d = new BukkitMetadata<E, V>(valueClass, getter, setter);
            this.metadataMap.put(name.toLowerCase(), d);
            if (alternativeName != null) {
                this.metadataMap.put(alternativeName.toLowerCase(), d);
            }
            if (!this.registered) {
                METADATA.put(this.clazz, this.metadataMap);
                this.registered = true;
            }
            return this;
        }

        public Builder<E> when(boolean condition, Consumer<Builder<E>> consumer) {
            if (condition) {
                consumer.accept(this);
            }
            return this;
        }

        public Builder<E> when(Supplier<Boolean> condition, Consumer<Builder<E>> consumer) {
            if (condition.get().booleanValue()) {
                consumer.accept(this);
            }
            return this;
        }

        public Builder<E> when(int major, int minor, Consumer<Builder<E>> consumer) {
            if (Version.isVersion(major, minor)) {
                consumer.accept(this);
            }
            return this;
        }

        public Builder<E> when(int major, int minor, int patch, Consumer<Builder<E>> consumer) {
            if (Version.isVersion(major, minor, patch)) {
                consumer.accept(this);
            }
            return this;
        }

        public Builder<E> whenNot(boolean condition, Consumer<Builder<E>> consumer) {
            if (!condition) {
                consumer.accept(this);
            }
            return this;
        }

        public Builder<E> whenNot(Supplier<Boolean> condition, Consumer<Builder<E>> consumer) {
            if (!condition.get().booleanValue()) {
                consumer.accept(this);
            }
            return this;
        }

        public Builder<E> whenNot(int major, int minor, Consumer<Builder<E>> consumer) {
            if (!Version.isVersion(major, minor)) {
                consumer.accept(this);
            }
            return this;
        }

        public Builder<E> whenNot(int major, int minor, int patch, Consumer<Builder<E>> consumer) {
            if (!Version.isVersion(major, minor, patch)) {
                consumer.accept(this);
            }
            return this;
        }

        public Builder(Class<E> clazz) {
            this.clazz = clazz;
        }
    }
}

