/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.entity;

import io.github.pronze.lib.kyori.adventure.audience.Audience;
import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.ComponentLike;
import io.github.pronze.lib.screaminglib.bukkit.BukkitCore;
import io.github.pronze.lib.screaminglib.bukkit.entity.BukkitEntityHuman;
import io.github.pronze.lib.screaminglib.bukkit.particle.BukkitParticleConverter;
import io.github.pronze.lib.screaminglib.bukkit.utils.nms.ClassStorage;
import io.github.pronze.lib.screaminglib.container.Container;
import io.github.pronze.lib.screaminglib.container.ContainerFactory;
import io.github.pronze.lib.screaminglib.container.Openable;
import io.github.pronze.lib.screaminglib.container.PlayerContainer;
import io.github.pronze.lib.screaminglib.entity.EntityBasic;
import io.github.pronze.lib.screaminglib.entity.EntityMapper;
import io.github.pronze.lib.screaminglib.nms.accessors.ConnectionAccessor;
import io.github.pronze.lib.screaminglib.nms.accessors.ServerGamePacketListenerImplAccessor;
import io.github.pronze.lib.screaminglib.nms.accessors.ServerPlayerAccessor;
import io.github.pronze.lib.screaminglib.particle.ParticleHolder;
import io.github.pronze.lib.screaminglib.player.PlayerMapper;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.player.gamemode.GameModeHolder;
import io.github.pronze.lib.screaminglib.utils.adventure.ComponentObjectLink;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import io.github.pronze.lib.screaminglib.world.LocationMapper;
import io.github.pronze.lib.screaminglib.world.weather.WeatherHolder;
import io.netty.channel.Channel;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.WeatherType;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitEntityPlayer
extends BukkitEntityHuman
implements PlayerWrapper {
    public BukkitEntityPlayer(Player wrappedObject) {
        super((HumanEntity)wrappedObject);
    }

    @Override
    public boolean isSprinting() {
        return ((Player)this.wrappedObject).isSprinting();
    }

    @Override
    public void setSprinting(boolean sprinting) {
        ((Player)this.wrappedObject).setSprinting(sprinting);
    }

    @Override
    public boolean isFlying() {
        return ((Player)this.wrappedObject).isFlying();
    }

    @Override
    public void setFlying(boolean flying) {
        ((Player)this.wrappedObject).setFlying(flying);
    }

    @Override
    public boolean isAllowFlight() {
        return ((Player)this.wrappedObject).getAllowFlight();
    }

    @Override
    public void setAllowFlight(boolean flying) {
        ((Player)this.wrappedObject).setAllowFlight(flying);
    }

    @Override
    public boolean isSneaking() {
        return ((Player)this.wrappedObject).isSneaking();
    }

    @Override
    public void setSneaking(boolean sneaking) {
        ((Player)this.wrappedObject).setSneaking(sneaking);
    }

    @Override
    public int getPing() {
        Object handle = ClassStorage.getHandle(this.wrappedObject);
        return Objects.requireNonNullElse(Reflect.getField(handle, ServerPlayerAccessor.getFieldLatency()), 0);
    }

    @Override
    @Nullable
    public Component getPlayerListName() {
        Player bukkitPlayer = (Player)this.wrappedObject;
        return ComponentObjectLink.processGetter(bukkitPlayer, "playerListName", () -> ((Player)bukkitPlayer).getPlayerListName());
    }

    @Override
    public void setPlayerListName(@Nullable Component component) {
        Player bukkitPlayer = (Player)this.wrappedObject;
        ComponentObjectLink.processSetter(bukkitPlayer, "playerListName", arg_0 -> ((Player)bukkitPlayer).setPlayerListName(arg_0), component);
    }

    @Override
    public void setPlayerListName(@Nullable ComponentLike component) {
        this.setPlayerListName(component != null ? component.asComponent() : null);
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        Player bukkitPlayer = (Player)this.wrappedObject;
        return ComponentObjectLink.processGetter(bukkitPlayer, "displayName", () -> ((Player)bukkitPlayer).getDisplayName());
    }

    @Override
    public void setDisplayName(@Nullable Component component) {
        Player bukkitPlayer = (Player)this.wrappedObject;
        ComponentObjectLink.processSetter(bukkitPlayer, "displayName", arg_0 -> ((Player)bukkitPlayer).setDisplayName(arg_0), component);
    }

    @Override
    public void setDisplayName(@Nullable ComponentLike component) {
        this.setDisplayName(component != null ? component.asComponent() : null);
    }

    @Override
    public void sendMessage(String message) {
        ((Entity)this.wrappedObject).sendMessage(message);
    }

    @Override
    public String getName() {
        return ((Entity)this.wrappedObject).getName();
    }

    @Override
    public void tryToDispatchCommand(String command) {
        Bukkit.dispatchCommand((CommandSender)((CommandSender)this.wrappedObject), (String)command);
    }

    @Override
    public Locale getLocale() {
        Player bukkitPlayer = (Player)this.wrappedObject;
        Locale locale = Locale.US;
        if (Reflect.hasMethod(bukkitPlayer, "getLocale", new Class[0])) {
            String locale2 = bukkitPlayer.getLocale();
            try {
                locale = Locale.forLanguageTag(locale2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return locale;
    }

    @Override
    public UUID getUuid() {
        return ((Entity)this.wrappedObject).getUniqueId();
    }

    @Override
    public Container getEnderChest() {
        return (Container)ContainerFactory.wrapContainer(((Player)this.wrappedObject).getEnderChest()).orElseThrow();
    }

    @Override
    public PlayerContainer getPlayerInventory() {
        return (PlayerContainer)ContainerFactory.wrapContainer(((Player)this.wrappedObject).getInventory()).orElseThrow();
    }

    @Override
    public Optional<Container> getOpenedInventory() {
        return ContainerFactory.wrapContainer(((Player)this.wrappedObject).getOpenInventory().getTopInventory());
    }

    @Override
    public void openInventory(Openable container) {
        container.openInventory(this);
    }

    @Override
    public void closeInventory() {
        ((Player)this.wrappedObject).closeInventory();
    }

    @Override
    public void kick(Component message) {
        Player bukkitPlayer = (Player)this.wrappedObject;
        ComponentObjectLink.processSetter(bukkitPlayer, "kick", arg_0 -> ((Player)bukkitPlayer).kickPlayer(arg_0), message);
    }

    @Override
    public void kick(ComponentLike message) {
        this.kick(message.asComponent());
    }

    @Override
    public GameModeHolder getGameMode() {
        return GameModeHolder.of(((Player)this.wrappedObject).getGameMode());
    }

    @Override
    public void setGameMode(@NotNull GameModeHolder gameMode) {
        ((Player)this.wrappedObject).setGameMode(gameMode.as(GameMode.class));
    }

    @Override
    public int getLevel() {
        return ((Player)this.wrappedObject).getLevel();
    }

    @Override
    public float getExp() {
        return ((Player)this.wrappedObject).getExp();
    }

    @Override
    public void setLevel(int level) {
        ((Player)this.wrappedObject).setLevel(level);
    }

    @Override
    public void setExp(float exp) {
        ((Player)this.wrappedObject).setExp(exp);
    }

    @Override
    public void forceUpdateInventory() {
        ((Player)this.wrappedObject).updateInventory();
    }

    @Override
    public Optional<String> getLastName() {
        return Optional.ofNullable(this.getName());
    }

    @Override
    public Optional<WeatherHolder> getPlayerWeather() {
        return WeatherHolder.ofOptional(((Player)this.wrappedObject).getPlayerWeather());
    }

    @Override
    public void setPlayerWeather(@Nullable WeatherHolder weather) {
        if (weather == null) {
            ((Player)this.wrappedObject).resetPlayerWeather();
        } else {
            ((Player)this.wrappedObject).setPlayerWeather(weather.as(WeatherType.class));
        }
    }

    @Override
    public long getPlayerTime() {
        return ((Player)this.wrappedObject).getPlayerTime();
    }

    @Override
    public void setPlayerTime(long time, boolean relative) {
        ((Player)this.wrappedObject).setPlayerTime(time, relative);
    }

    @Override
    public void resetPlayerTime() {
        ((Player)this.wrappedObject).resetPlayerTime();
    }

    @Override
    public void sendParticle(ParticleHolder particle, LocationHolder location) {
        ((Player)this.wrappedObject).spawnParticle(particle.particleType().as(Particle.class), location.as(Location.class), particle.count(), particle.offset().getX(), particle.offset().getY(), particle.offset().getZ(), particle.particleData(), particle.specialData() != null ? BukkitParticleConverter.convertParticleData(particle.specialData()) : null);
    }

    @Override
    public void setCompassTarget(LocationHolder location) {
        ((Player)this.wrappedObject).setCompassTarget(location.as(Location.class));
    }

    @Override
    public void restoreDefaultScoreboard() {
        ((Player)this.wrappedObject).setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
    }

    @Override
    public Optional<EntityBasic> getSpectatorTarget() {
        Entity target = ((Player)this.wrappedObject).getSpectatorTarget();
        if (target == null) {
            return Optional.empty();
        }
        return EntityMapper.wrapEntity(target);
    }

    @Override
    public void setSpectatorTarget(@Nullable EntityBasic entity) {
        ((Player)this.wrappedObject).setSpectatorTarget(entity == null ? null : entity.as(Entity.class));
    }

    @Override
    public LocationHolder getCompassTarget() {
        return LocationMapper.wrapLocation(((Player)this.wrappedObject).getCompassTarget());
    }

    @Override
    public Channel getChannel() {
        return (Channel)Reflect.getFieldResulted(ClassStorage.getHandle(this.wrappedObject), ServerPlayerAccessor.getFieldConnection()).getFieldResulted(ServerGamePacketListenerImplAccessor.getFieldConnection()).getFieldResulted(ConnectionAccessor.getFieldChannel()).raw();
    }

    @Override
    @NotNull
    public Audience audience() {
        return BukkitCore.audiences().player((Player)this.wrappedObject);
    }

    @Override
    public <T> T as(Class<T> type) {
        try {
            return super.as(type);
        }
        catch (UnsupportedOperationException ignored) {
            return PlayerMapper.UNSAFE_getPlayerConverter().convert(this, type);
        }
    }
}

