/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.event.player;

import io.github.pronze.lib.screaminglib.block.BlockHolder;
import io.github.pronze.lib.screaminglib.block.BlockMapper;
import io.github.pronze.lib.screaminglib.block.state.BlockStateHolder;
import io.github.pronze.lib.screaminglib.block.state.BlockStateMapper;
import io.github.pronze.lib.screaminglib.bukkit.entity.BukkitEntityPlayer;
import io.github.pronze.lib.screaminglib.bukkit.event.BukkitCancellable;
import io.github.pronze.lib.screaminglib.bukkit.item.BukkitItem;
import io.github.pronze.lib.screaminglib.event.player.SPlayerBlockPlaceEvent;
import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.player.PlayerMapper;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.utils.ImmutableCollectionLinkedToCollection;
import java.util.Collection;
import java.util.List;
import org.bukkit.block.BlockState;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPlaceEvent;

public class SBukkitPlayerBlockPlaceEvent
implements SPlayerBlockPlaceEvent,
BukkitCancellable {
    private final BlockPlaceEvent event;
    private PlayerWrapper player;
    private Collection<BlockStateHolder> replacedBlockStates;
    private PlayerWrapper.Hand playerHand;
    private BlockHolder block;
    private BlockStateHolder replacedBlockState;
    private Item itemInHand;

    @Override
    public Collection<BlockStateHolder> getReplacedBlockStates() {
        if (this.replacedBlockStates == null) {
            this.replacedBlockStates = this.event instanceof BlockMultiPlaceEvent ? new ImmutableCollectionLinkedToCollection<BlockStateHolder, BlockState>(((BlockMultiPlaceEvent)this.event).getReplacedBlockStates(), blockStateHolder -> blockStateHolder.as(BlockState.class), blockState -> (BlockStateHolder)BlockStateMapper.wrapBlockState(blockState).orElseThrow()) : List.of(this.getReplacedBlockState());
        }
        return this.replacedBlockStates;
    }

    @Override
    public PlayerWrapper.Hand getPlayerHand() {
        if (this.playerHand == null) {
            this.playerHand = PlayerMapper.wrapHand(this.event.getHand());
        }
        return this.playerHand;
    }

    @Override
    public BlockHolder getBlock() {
        if (this.block == null) {
            this.block = BlockMapper.wrapBlock(this.event.getBlock());
        }
        return this.block;
    }

    @Override
    public BlockStateHolder getReplacedBlockState() {
        if (this.replacedBlockState == null) {
            this.replacedBlockState = (BlockStateHolder)BlockStateMapper.wrapBlockState(this.event.getBlockReplacedState()).orElseThrow();
        }
        return this.replacedBlockState;
    }

    @Override
    public Item getItemInHand() {
        if (this.itemInHand == null) {
            this.itemInHand = new BukkitItem(this.event.getItemInHand());
        }
        return this.itemInHand;
    }

    @Override
    public PlayerWrapper getPlayer() {
        if (this.player == null) {
            this.player = new BukkitEntityPlayer(this.event.getPlayer());
        }
        return this.player;
    }

    public SBukkitPlayerBlockPlaceEvent(BlockPlaceEvent event) {
        this.event = event;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SBukkitPlayerBlockPlaceEvent)) {
            return false;
        }
        SBukkitPlayerBlockPlaceEvent other = (SBukkitPlayerBlockPlaceEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BlockPlaceEvent this$event = this.getEvent();
        BlockPlaceEvent other$event = other.getEvent();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SBukkitPlayerBlockPlaceEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BlockPlaceEvent $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    public String toString() {
        return "SBukkitPlayerBlockPlaceEvent(event=" + this.getEvent() + ")";
    }

    public BlockPlaceEvent getEvent() {
        return this.event;
    }
}

