/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.event.player;

import io.github.pronze.lib.screaminglib.block.BlockHolder;
import io.github.pronze.lib.screaminglib.block.BlockMapper;
import io.github.pronze.lib.screaminglib.bukkit.entity.BukkitEntityPlayer;
import io.github.pronze.lib.screaminglib.bukkit.event.BukkitCancellable;
import io.github.pronze.lib.screaminglib.bukkit.item.BukkitItem;
import io.github.pronze.lib.screaminglib.event.player.SPlayerBucketEvent;
import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.item.ItemTypeHolder;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.utils.BlockFace;
import org.bukkit.event.player.PlayerBucketEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class SBukkitPlayerBucketEvent
implements SPlayerBucketEvent,
BukkitCancellable {
    private final PlayerBucketEvent event;
    private PlayerWrapper player;
    private BlockHolder block;
    private BlockHolder blockClicked;
    private BlockFace blockFace;
    private ItemTypeHolder bucket;

    @Override
    public PlayerWrapper getPlayer() {
        if (this.player == null) {
            this.player = new BukkitEntityPlayer(this.event.getPlayer());
        }
        return this.player;
    }

    @Override
    public BlockHolder getBlock() {
        if (this.block == null) {
            this.block = BlockMapper.wrapBlock(this.event.getBlock());
        }
        return this.block;
    }

    @Override
    public BlockHolder getBlockClicked() {
        if (this.blockClicked == null) {
            this.blockClicked = BlockMapper.wrapBlock(this.event.getBlockClicked());
        }
        return this.blockClicked;
    }

    @Override
    public BlockFace getBlockFace() {
        if (this.blockFace == null) {
            this.blockFace = BlockFace.valueOf(this.event.getBlockFace().name());
        }
        return this.blockFace;
    }

    @Override
    public ItemTypeHolder getBucket() {
        if (this.bucket == null) {
            this.bucket = ItemTypeHolder.of(this.event.getBucket());
        }
        return this.bucket;
    }

    @Override
    @Nullable
    public Item getItem() {
        return this.event.getItemStack() != null ? new BukkitItem(this.event.getItemStack()) : null;
    }

    @Override
    public void setItem(@Nullable Item item) {
        this.event.setItemStack(item == null ? null : item.as(ItemStack.class));
    }

    @Override
    public SPlayerBucketEvent.Action getAction() {
        return this.event instanceof PlayerBucketFillEvent ? SPlayerBucketEvent.Action.FILL : SPlayerBucketEvent.Action.EMPTY;
    }

    public SBukkitPlayerBucketEvent(PlayerBucketEvent event) {
        this.event = event;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SBukkitPlayerBucketEvent)) {
            return false;
        }
        SBukkitPlayerBucketEvent other = (SBukkitPlayerBucketEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PlayerBucketEvent this$event = this.getEvent();
        PlayerBucketEvent other$event = other.getEvent();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SBukkitPlayerBucketEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PlayerBucketEvent $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    public String toString() {
        return "SBukkitPlayerBucketEvent(event=" + this.getEvent() + ")";
    }

    public PlayerBucketEvent getEvent() {
        return this.event;
    }
}

