/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.event.player;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.ComponentLike;
import io.github.pronze.lib.screaminglib.bukkit.entity.BukkitEntityPlayer;
import io.github.pronze.lib.screaminglib.bukkit.event.entity.SBukkitEntityDeathEvent;
import io.github.pronze.lib.screaminglib.event.player.SPlayerDeathEvent;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.sender.SenderMessage;
import io.github.pronze.lib.screaminglib.utils.adventure.ComponentObjectLink;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.jetbrains.annotations.Nullable;

public class SBukkitPlayerDeathEvent
extends SBukkitEntityDeathEvent
implements SPlayerDeathEvent {
    @Nullable
    private final Player bukkitKiller;
    @Nullable
    private PlayerWrapper killer;

    public SBukkitPlayerDeathEvent(PlayerDeathEvent event) {
        super((EntityDeathEvent)event);
        this.bukkitKiller = event.getEntity().getKiller();
    }

    @Override
    public Component getDeathMessage() {
        return ComponentObjectLink.processGetter(this.getEvent(), "deathMessage", () -> ((PlayerDeathEvent)this.getEvent()).getDeathMessage());
    }

    @Override
    public void setDeathMessage(Component deathMessage) {
        ComponentObjectLink.processSetter(this.getEvent(), "deathMessage", arg_0 -> ((PlayerDeathEvent)this.getEvent()).setDeathMessage(arg_0), deathMessage);
    }

    @Override
    public void setDeathMessage(ComponentLike deathMessage) {
        if (deathMessage instanceof SenderMessage) {
            this.setDeathMessage(((SenderMessage)deathMessage).asComponent(this.getPlayer()));
        } else {
            this.setDeathMessage(deathMessage != null ? deathMessage.asComponent() : null);
        }
    }

    @Override
    public boolean isKeepInventory() {
        return this.getEvent().getKeepInventory();
    }

    @Override
    public void setKeepInventory(boolean keepInventory) {
        this.getEvent().setKeepInventory(keepInventory);
    }

    @Override
    public boolean isShouldDropExperience() {
        return this.getEvent().shouldDropExperience();
    }

    @Override
    public void setShouldDropExperience(boolean shouldDropExperience) {
        this.getEvent().setShouldDropExperience(shouldDropExperience);
    }

    @Override
    public boolean isKeepLevel() {
        return this.getEvent().getKeepLevel();
    }

    @Override
    public void setKeepLevel(boolean keepLevel) {
        this.getEvent().setKeepLevel(keepLevel);
    }

    @Override
    public int getNewLevel() {
        return this.getEvent().getNewLevel();
    }

    @Override
    public void setNewLevel(int newLevel) {
        this.getEvent().setNewLevel(newLevel);
    }

    @Override
    public int getNewTotalExp() {
        return this.getEvent().getNewTotalExp();
    }

    @Override
    public void setNewTotalExp(int newTotalExp) {
        this.getEvent().setNewTotalExp(newTotalExp);
    }

    @Override
    public int getNewExp() {
        return this.getEvent().getNewExp();
    }

    @Override
    public void setNewExp(int newExp) {
        this.getEvent().setNewExp(newExp);
    }

    @Override
    public int getDroppedExp() {
        return this.getEvent().getDroppedExp();
    }

    @Override
    public void setDroppedExp(int droppedExp) {
        this.getEvent().setDroppedExp(droppedExp);
    }

    @Override
    @Nullable
    public PlayerWrapper getKiller() {
        if (this.bukkitKiller != null && this.killer == null) {
            this.killer = new BukkitEntityPlayer(this.bukkitKiller);
        }
        return this.killer;
    }

    @Override
    public PlayerWrapper getPlayer() {
        return (PlayerWrapper)this.getEntity();
    }

    public PlayerDeathEvent getEvent() {
        return (PlayerDeathEvent)super.getEvent();
    }
}

