/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.event.player;

import io.github.pronze.lib.screaminglib.bukkit.entity.BukkitEntityPlayer;
import io.github.pronze.lib.screaminglib.bukkit.event.BukkitCancellable;
import io.github.pronze.lib.screaminglib.entity.EntityBasic;
import io.github.pronze.lib.screaminglib.entity.EntityMapper;
import io.github.pronze.lib.screaminglib.event.player.SPlayerFishEvent;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import org.bukkit.event.player.PlayerFishEvent;
import org.jetbrains.annotations.Nullable;

public class SBukkitPlayerFishEvent
implements SPlayerFishEvent,
BukkitCancellable {
    private final PlayerFishEvent event;
    private PlayerWrapper player;
    private EntityBasic entity;
    private boolean entityCached;
    private SPlayerFishEvent.State state;
    private EntityBasic hookEntity;

    @Override
    public PlayerWrapper getPlayer() {
        if (this.player == null) {
            this.player = new BukkitEntityPlayer(this.event.getPlayer());
        }
        return this.player;
    }

    @Override
    @Nullable
    public EntityBasic getEntity() {
        if (!this.entityCached) {
            if (this.event.getCaught() != null) {
                this.entity = (EntityBasic)EntityMapper.wrapEntity(this.event.getCaught()).orElseThrow();
            }
            this.entityCached = true;
        }
        return this.entity;
    }

    @Override
    public int getExp() {
        return this.event.getExpToDrop();
    }

    @Override
    public void setExp(int exp) {
        this.event.setExpToDrop(exp);
    }

    @Override
    public SPlayerFishEvent.State getState() {
        if (this.state == null) {
            this.state = SPlayerFishEvent.State.convert(this.event.getState().name());
        }
        return this.state;
    }

    @Override
    public EntityBasic getHookEntity() {
        if (this.hookEntity == null) {
            this.hookEntity = (EntityBasic)EntityMapper.wrapEntity(this.event.getHook()).orElseThrow();
        }
        return this.hookEntity;
    }

    public SBukkitPlayerFishEvent(PlayerFishEvent event) {
        this.event = event;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SBukkitPlayerFishEvent)) {
            return false;
        }
        SBukkitPlayerFishEvent other = (SBukkitPlayerFishEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PlayerFishEvent this$event = this.getEvent();
        PlayerFishEvent other$event = other.getEvent();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SBukkitPlayerFishEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PlayerFishEvent $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    public String toString() {
        return "SBukkitPlayerFishEvent(event=" + this.getEvent() + ")";
    }

    public PlayerFishEvent getEvent() {
        return this.event;
    }
}

