/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.event.player;

import io.github.pronze.lib.screaminglib.block.BlockHolder;
import io.github.pronze.lib.screaminglib.block.BlockMapper;
import io.github.pronze.lib.screaminglib.bukkit.entity.BukkitEntityPlayer;
import io.github.pronze.lib.screaminglib.bukkit.event.NoAutoCancellable;
import io.github.pronze.lib.screaminglib.bukkit.item.BukkitItemView;
import io.github.pronze.lib.screaminglib.event.SEvent;
import io.github.pronze.lib.screaminglib.event.player.SPlayerInteractEvent;
import io.github.pronze.lib.screaminglib.item.ItemView;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.slot.EquipmentSlotHolder;
import io.github.pronze.lib.screaminglib.utils.BlockFace;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerInteractEvent;
import org.jetbrains.annotations.Nullable;

public class SBukkitPlayerInteractEvent
implements SPlayerInteractEvent,
NoAutoCancellable {
    private final PlayerInteractEvent event;
    private PlayerWrapper player;
    private ItemView item;
    private boolean itemCached;
    private SPlayerInteractEvent.Action action;
    private BlockFace blockFace;
    private BlockHolder clickedBlock;
    private boolean clickedBlockCached;
    private EquipmentSlotHolder hand;
    private boolean handCached;

    @Override
    public PlayerWrapper getPlayer() {
        if (this.player == null) {
            this.player = new BukkitEntityPlayer(this.event.getPlayer());
        }
        return this.player;
    }

    @Override
    @Nullable
    public ItemView getItem() {
        if (!this.itemCached) {
            if (this.event.getItem() != null) {
                this.item = new BukkitItemView(this.event.getItem());
            }
            this.itemCached = true;
        }
        return this.item;
    }

    @Override
    public SPlayerInteractEvent.Action getAction() {
        if (this.action == null) {
            this.action = SPlayerInteractEvent.Action.convert(this.event.getAction().name());
        }
        return this.action;
    }

    @Override
    @Nullable
    public BlockHolder getBlockClicked() {
        if (!this.clickedBlockCached) {
            if (this.event.getClickedBlock() != null) {
                this.clickedBlock = BlockMapper.wrapBlock(this.event.getClickedBlock());
            }
            this.clickedBlockCached = true;
        }
        return this.clickedBlock;
    }

    @Override
    public BlockFace getBlockFace() {
        if (this.blockFace == null) {
            this.blockFace = BlockFace.valueOf(this.event.getBlockFace().name());
        }
        return this.blockFace;
    }

    @Override
    public SEvent.Result getUseClickedBlock() {
        return SEvent.Result.convert(this.event.useInteractedBlock().name());
    }

    @Override
    public void setUseClickedBlock(SEvent.Result useClickedBlock) {
        this.event.setUseInteractedBlock(Event.Result.valueOf((String)useClickedBlock.name()));
    }

    @Override
    public SEvent.Result getUseItemInHand() {
        return SEvent.Result.convert(this.event.useItemInHand().name());
    }

    @Override
    public void setUseItemInHand(SEvent.Result useItemInHand) {
        this.event.setUseItemInHand(Event.Result.valueOf((String)useItemInHand.name()));
    }

    @Override
    @Nullable
    public EquipmentSlotHolder getHand() {
        if (!this.handCached) {
            if (this.event.getHand() != null) {
                this.hand = EquipmentSlotHolder.of(this.event.getHand());
            }
            this.handCached = true;
        }
        return this.hand;
    }

    public SBukkitPlayerInteractEvent(PlayerInteractEvent event) {
        this.event = event;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SBukkitPlayerInteractEvent)) {
            return false;
        }
        SBukkitPlayerInteractEvent other = (SBukkitPlayerInteractEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PlayerInteractEvent this$event = this.getEvent();
        PlayerInteractEvent other$event = other.getEvent();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SBukkitPlayerInteractEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PlayerInteractEvent $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    public String toString() {
        return "SBukkitPlayerInteractEvent(event=" + this.getEvent() + ")";
    }

    public PlayerInteractEvent getEvent() {
        return this.event;
    }
}

