/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.event.player;

import io.github.pronze.lib.screaminglib.bukkit.entity.BukkitEntityPlayer;
import io.github.pronze.lib.screaminglib.bukkit.event.BukkitCancellable;
import io.github.pronze.lib.screaminglib.bukkit.world.BukkitWorldHolder;
import io.github.pronze.lib.screaminglib.event.player.SPlayerMoveEvent;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.world.LocationHolder;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.player.PlayerMoveEvent;

public class SBukkitPlayerMoveEvent
implements SPlayerMoveEvent,
BukkitCancellable {
    private final PlayerMoveEvent event;
    private PlayerWrapper player;
    private Location currentLocationBukkit;
    private LocationHolder currentLocation;
    private Location newLocationBukkit;
    private LocationHolder newLocation;

    @Override
    public PlayerWrapper getPlayer() {
        if (this.player == null) {
            this.player = new BukkitEntityPlayer(this.event.getPlayer());
        }
        return this.player;
    }

    @Override
    public LocationHolder getCurrentLocation() {
        if (this.event.getFrom() != this.currentLocationBukkit) {
            this.currentLocationBukkit = this.event.getFrom();
            this.currentLocation = new LocationHolder(this.currentLocationBukkit.getX(), this.currentLocationBukkit.getY(), this.currentLocationBukkit.getZ(), this.currentLocationBukkit.getYaw(), this.currentLocationBukkit.getPitch(), new BukkitWorldHolder(this.currentLocationBukkit.getWorld()));
        }
        return this.currentLocation;
    }

    @Override
    public LocationHolder getNewLocation() {
        if (this.event.getTo() != this.newLocationBukkit) {
            this.newLocationBukkit = this.event.getTo();
            this.newLocation = new LocationHolder(this.newLocationBukkit.getX(), this.newLocationBukkit.getY(), this.newLocationBukkit.getZ(), this.newLocationBukkit.getYaw(), this.newLocationBukkit.getPitch(), new BukkitWorldHolder(this.newLocationBukkit.getWorld()));
        }
        return this.newLocation;
    }

    @Override
    public void setNewLocation(LocationHolder newLocation) {
        this.event.setTo(new Location(newLocation.getWorld().as(World.class), newLocation.getX(), newLocation.getY(), newLocation.getZ(), newLocation.getYaw(), newLocation.getPitch()));
    }

    public SBukkitPlayerMoveEvent(PlayerMoveEvent event) {
        this.event = event;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SBukkitPlayerMoveEvent)) {
            return false;
        }
        SBukkitPlayerMoveEvent other = (SBukkitPlayerMoveEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PlayerMoveEvent this$event = this.getEvent();
        PlayerMoveEvent other$event = other.getEvent();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SBukkitPlayerMoveEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PlayerMoveEvent $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    public String toString() {
        return "SBukkitPlayerMoveEvent(event=" + this.getEvent() + ")";
    }

    public PlayerMoveEvent getEvent() {
        return this.event;
    }
}

