/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.event.player;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.screaminglib.block.BlockHolder;
import io.github.pronze.lib.screaminglib.block.BlockMapper;
import io.github.pronze.lib.screaminglib.bukkit.entity.BukkitEntityPlayer;
import io.github.pronze.lib.screaminglib.bukkit.event.BukkitCancellable;
import io.github.pronze.lib.screaminglib.event.player.SPlayerUpdateSignEvent;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.utils.AdventureHelper;
import java.util.Arrays;
import org.bukkit.event.block.SignChangeEvent;
import org.jetbrains.annotations.Range;

public class SBukkitPlayerUpdateSignEvent
implements SPlayerUpdateSignEvent,
BukkitCancellable {
    private final SignChangeEvent event;
    private PlayerWrapper player;
    private BlockHolder block;

    @Override
    public PlayerWrapper getPlayer() {
        if (this.player == null) {
            this.player = new BukkitEntityPlayer(this.event.getPlayer());
        }
        return this.player;
    }

    @Override
    public BlockHolder getBlock() {
        if (this.block == null) {
            this.block = BlockMapper.wrapBlock(this.event.getBlock());
        }
        return this.block;
    }

    @Override
    public Component[] lines() {
        return (Component[])Arrays.stream(this.event.getLines()).map(AdventureHelper::toComponent).toArray(Component[]::new);
    }

    @Override
    public Component line(@Range(from=0L, to=3L) int index) {
        return this.lines()[index];
    }

    @Override
    public void line(@Range(from=0L, to=3L) int index, Component component) {
        this.event.setLine(index, AdventureHelper.toLegacy(component));
    }

    public SBukkitPlayerUpdateSignEvent(SignChangeEvent event) {
        this.event = event;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SBukkitPlayerUpdateSignEvent)) {
            return false;
        }
        SBukkitPlayerUpdateSignEvent other = (SBukkitPlayerUpdateSignEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SignChangeEvent this$event = this.getEvent();
        SignChangeEvent other$event = other.getEvent();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SBukkitPlayerUpdateSignEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SignChangeEvent $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    public String toString() {
        return "SBukkitPlayerUpdateSignEvent(event=" + this.getEvent() + ")";
    }

    public SignChangeEvent getEvent() {
        return this.event;
    }
}

