/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.item;

import io.github.pronze.lib.screaminglib.block.BlockTypeHolder;
import io.github.pronze.lib.screaminglib.item.ItemTypeHolder;
import io.github.pronze.lib.screaminglib.utils.BasicWrapper;
import io.github.pronze.lib.screaminglib.utils.Pair;
import java.util.Arrays;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class BukkitItemTypeLegacyHolder
extends BasicWrapper<Pair<Material, Short>>
implements ItemTypeHolder {
    public BukkitItemTypeLegacyHolder(Material material) {
        this(Pair.of(material, (short)0));
    }

    public BukkitItemTypeLegacyHolder(Material material, short forcedDurability) {
        this(Pair.of(material, forcedDurability));
    }

    public BukkitItemTypeLegacyHolder(Pair<Material, Short> wrappedObject) {
        super(wrappedObject);
    }

    @Override
    public String platformName() {
        return ((Material)((Pair)this.wrappedObject).first()).name();
    }

    @Override
    public short forcedDurability() {
        return (Short)((Pair)this.wrappedObject).second();
    }

    @Override
    public int maxStackSize() {
        return ((Material)((Pair)this.wrappedObject).first()).getMaxStackSize();
    }

    @Override
    public ItemTypeHolder withForcedDurability(short durability) {
        return new BukkitItemTypeLegacyHolder(Pair.of((Material)((Pair)this.wrappedObject).first(), durability));
    }

    @Override
    public Optional<BlockTypeHolder> block() {
        if (!((Material)((Pair)this.wrappedObject).first()).isBlock()) {
            return Optional.empty();
        }
        return Optional.of(BlockTypeHolder.of(((Pair)this.wrappedObject).first()).withLegacyData(((Short)((Pair)this.wrappedObject).second()).byteValue()));
    }

    @Override
    public boolean is(Object object) {
        if (object instanceof Material && (Short)((Pair)this.wrappedObject).second() == 0) {
            return ((Material)((Pair)this.wrappedObject).first()).equals(object);
        }
        if (object instanceof ItemTypeHolder) {
            return this.equals(object);
        }
        return this.equals(ItemTypeHolder.ofOptional(object).orElse(null));
    }

    @Override
    public boolean is(Object ... objects) {
        return Arrays.stream(objects).anyMatch(this::is);
    }

    @Override
    public <T> T as(Class<T> type) {
        if (type == Material.class) {
            return (T)((Pair)this.wrappedObject).first();
        }
        if (type == ItemStack.class) {
            return (T)new ItemStack((Material)((Pair)this.wrappedObject).first(), 1, ((Short)((Pair)this.wrappedObject).second()).shortValue());
        }
        return super.as(type);
    }
}

