/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.item.builder;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.screaminglib.attribute.ItemAttributeHolder;
import io.github.pronze.lib.screaminglib.bukkit.BukkitItemBlockIdsRemapper;
import io.github.pronze.lib.screaminglib.bukkit.attribute.BukkitItemAttribute;
import io.github.pronze.lib.screaminglib.bukkit.item.BukkitItem;
import io.github.pronze.lib.screaminglib.bukkit.item.ItemMetaHelper;
import io.github.pronze.lib.screaminglib.bukkit.item.data.BukkitItemDataCustomTags;
import io.github.pronze.lib.screaminglib.bukkit.item.data.BukkitItemDataPersistentContainer;
import io.github.pronze.lib.screaminglib.bukkit.item.data.CraftBukkitItemData;
import io.github.pronze.lib.screaminglib.item.HideFlags;
import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.item.ItemTypeHolder;
import io.github.pronze.lib.screaminglib.item.builder.ItemBuilder;
import io.github.pronze.lib.screaminglib.item.data.ItemData;
import io.github.pronze.lib.screaminglib.item.meta.EnchantmentHolder;
import io.github.pronze.lib.screaminglib.metadata.MetadataCollectionKey;
import io.github.pronze.lib.screaminglib.metadata.MetadataKey;
import io.github.pronze.lib.screaminglib.nms.accessors.CompoundTagAccessor;
import io.github.pronze.lib.screaminglib.utils.AdventureHelper;
import io.github.pronze.lib.screaminglib.utils.Platform;
import io.github.pronze.lib.screaminglib.utils.adventure.AdventureUtils;
import io.github.pronze.lib.screaminglib.utils.adventure.ComponentObjectLink;
import io.github.pronze.lib.screaminglib.utils.adventure.ComponentUtils;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.Repairable;
import org.bukkit.inventory.meta.tags.CustomItemTagContainer;
import org.bukkit.persistence.PersistentDataContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitItemBuilder
implements ItemBuilder {
    private ItemStack item;

    @Override
    public ItemBuilder type(@NotNull ItemTypeHolder type) {
        if (this.item == null) {
            this.item = new ItemStack(Material.AIR);
        }
        this.item.setType(type.as(Material.class));
        if (type.forcedDurability() != 0) {
            this.durability(type.forcedDurability());
        }
        return this;
    }

    @Override
    public ItemBuilder durability(int durability) {
        return this.durability((short)durability);
    }

    public ItemBuilder durability(short durability) {
        if (BukkitItemBlockIdsRemapper.getBPlatform() == Platform.JAVA_LEGACY) {
            this.item.setDurability(durability);
        } else {
            ItemMeta meta = this.item.getItemMeta();
            if (meta instanceof Damageable) {
                ((Damageable)meta).setDamage((int)durability);
                this.item.setItemMeta(meta);
            }
        }
        return this;
    }

    @Override
    public ItemBuilder amount(int amount) {
        if (this.item == null) {
            return this;
        }
        this.item.setAmount(amount);
        return this;
    }

    @Override
    public ItemBuilder displayName(@Nullable Component displayName) {
        if (this.item == null) {
            return this;
        }
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            ComponentObjectLink.processSetter(meta, "displayName", arg_0 -> ((ItemMeta)meta).setDisplayName(arg_0), displayName);
            this.item.setItemMeta(meta);
        }
        return this;
    }

    @Override
    public ItemBuilder itemLore(@Nullable List<@NotNull Component> lore) {
        if (this.item == null) {
            return this;
        }
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            if (lore == null) {
                meta.setLore(null);
            } else {
                AdventureUtils.get(meta, "lore", List.class).ifPresentOrElse(classMethod -> classMethod.invokeInstance(meta, lore.stream().map(ComponentUtils::componentToPlatform).collect(Collectors.toList())), () -> meta.setLore(lore.stream().map(AdventureHelper::toLegacy).collect(Collectors.toList())));
            }
            this.item.setItemMeta(meta);
        }
        return this;
    }

    @Override
    public ItemBuilder attributeModifiers(@Nullable List<@NotNull ItemAttributeHolder> modifiers) {
        if (this.item == null) {
            return this;
        }
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null && Reflect.hasMethod(meta, "hasAttributeModifiers", new Class[0])) {
            meta.setAttributeModifiers(null);
            if (modifiers != null) {
                modifiers.stream().map(holder -> holder.as(BukkitItemAttribute.class)).forEach(holder -> meta.addAttributeModifier(holder.getAttribute(), holder.getAttributeModifier()));
            }
            this.item.setItemMeta(meta);
        }
        return this;
    }

    @Override
    public ItemBuilder attributeModifier(@NotNull ItemAttributeHolder modifier) {
        if (this.item == null) {
            return this;
        }
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null && Reflect.hasMethod(meta, "hasAttributeModifiers", new Class[0])) {
            BukkitItemAttribute mod = modifier.as(BukkitItemAttribute.class);
            meta.addAttributeModifier(mod.getAttribute(), mod.getAttributeModifier());
            this.item.setItemMeta(meta);
        }
        return this;
    }

    @Override
    public ItemBuilder data(@NotNull ItemData data) {
        if (this.item == null) {
            return this;
        }
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            if (Reflect.hasMethod(meta, "getPersistentDataContainer", new Class[0])) {
                if (data instanceof BukkitItemDataPersistentContainer && !data.isEmpty()) {
                    PersistentDataContainer origDataContainer = ((BukkitItemDataPersistentContainer)data).getDataContainer();
                    Reflect.getMethod((Object)meta.getPersistentDataContainer(), "putAll", Map.class).invoke(Reflect.fastInvoke((Object)origDataContainer, "getRaw"));
                    this.item.setItemMeta(meta);
                }
            } else if (Reflect.hasMethod(meta, "getCustomTagContainer", new Class[0])) {
                if (data instanceof BukkitItemDataCustomTags && !data.isEmpty()) {
                    CustomItemTagContainer origDataContainer = ((BukkitItemDataCustomTags)data).getDataContainer();
                    Reflect.getMethod((Object)meta.getCustomTagContainer(), "putAll", Map.class).invoke(Reflect.fastInvoke((Object)origDataContainer, "getRaw"));
                    this.item.setItemMeta(meta);
                }
            } else if (data instanceof CraftBukkitItemData && !data.isEmpty()) {
                Object compound;
                Map unhandled = (Map)Reflect.getField((Object)meta, "unhandledTags");
                if (unhandled.containsKey("PublicBukkitValues")) {
                    compound = unhandled.get("PublicBukkitValues");
                } else {
                    compound = Reflect.construct(CompoundTagAccessor.getConstructor0(), new Object[0]);
                    unhandled.put("PublicBukkitValues", compound);
                }
                ((CraftBukkitItemData)data).getKeyNBTMap().forEach((s, o) -> Reflect.fastInvoke(compound, CompoundTagAccessor.getMethodPut1(), s, o));
                this.item.setItemMeta(meta);
            }
        }
        return this;
    }

    @Override
    public ItemBuilder hideFlags(@Nullable List<@NotNull HideFlags> flags) {
        if (this.item == null) {
            return this;
        }
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            try {
                meta.removeItemFlags((ItemFlag[])meta.getItemFlags().toArray(ItemFlag[]::new));
                if (flags != null) {
                    meta.addItemFlags((ItemFlag[])flags.stream().map(HideFlags::getBukkitName).map(ItemFlag::valueOf).toArray(ItemFlag[]::new));
                }
                this.item.setItemMeta(meta);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this;
    }

    @Override
    public ItemBuilder hideFlag(@NotNull HideFlags flag) {
        if (this.item == null) {
            return this;
        }
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            try {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.valueOf((String)flag.getBukkitName())});
                this.item.setItemMeta(meta);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this;
    }

    @Override
    public ItemBuilder enchantments(@Nullable List<@NotNull EnchantmentHolder> enchantments) {
        if (this.item == null) {
            return this;
        }
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            meta.getEnchants().keySet().forEach(arg_0 -> ((ItemMeta)meta).removeEnchant(arg_0));
            if (enchantments != null) {
                enchantments.forEach(e -> {
                    if (meta instanceof EnchantmentStorageMeta) {
                        ((EnchantmentStorageMeta)meta).addStoredEnchant(e.as(Enchantment.class), e.level(), true);
                    } else {
                        meta.addEnchant(e.as(Enchantment.class), e.level(), true);
                    }
                });
            }
            this.item.setItemMeta(meta);
        }
        return this;
    }

    @Override
    public ItemBuilder enchantment(@NotNull EnchantmentHolder enchantment) {
        if (this.item == null) {
            return this;
        }
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            if (meta instanceof EnchantmentStorageMeta) {
                ((EnchantmentStorageMeta)meta).addStoredEnchant(enchantment.as(Enchantment.class), enchantment.level(), true);
            } else {
                meta.addEnchant(enchantment.as(Enchantment.class), enchantment.level(), true);
            }
            this.item.setItemMeta(meta);
        }
        return this;
    }

    @Override
    public ItemBuilder customModelData(@Nullable Integer data) {
        if (this.item == null) {
            return this;
        }
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            try {
                meta.setCustomModelData(data);
                this.item.setItemMeta(meta);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this;
    }

    @Override
    public ItemBuilder unbreakable(boolean unbreakable) {
        if (this.item == null) {
            return this;
        }
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            if (Reflect.hasMethod(meta, "setUnbreakable", Boolean.TYPE)) {
                meta.setUnbreakable(unbreakable);
                this.item.setItemMeta(meta);
            } else {
                Object spigot = Reflect.fastInvoke((Object)meta, "spigot");
                if (spigot != null) {
                    Reflect.getMethod(spigot, "setUnbreakable", Boolean.TYPE).invoke(unbreakable);
                    this.item.setItemMeta(meta);
                }
            }
        }
        return this;
    }

    @Override
    public ItemBuilder repairCost(int repairCost) {
        if (this.item == null) {
            return this;
        }
        ItemMeta meta = this.item.getItemMeta();
        if (meta instanceof Repairable) {
            ((Repairable)meta).setRepairCost(repairCost);
        }
        return this;
    }

    @Override
    public Optional<Item> build() {
        if (this.item != null) {
            return Optional.of(new BukkitItem(this.item.clone()));
        }
        return Optional.empty();
    }

    @Override
    public ItemBuilder platformMeta(Object meta) {
        if (this.item == null) {
            return this;
        }
        if (meta instanceof ItemMeta) {
            try {
                this.item.setItemMeta((ItemMeta)meta);
            }
            catch (Throwable throwable) {}
        } else if (meta instanceof Map) {
            try {
                this.item.setItemMeta((ItemMeta)ConfigurationSerialization.deserializeObject((Map)((Map)meta)));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this;
    }

    @Override
    public ItemBuilder lore(@NotNull Component component) {
        ItemMeta meta;
        if (this.item != null && (meta = this.item.getItemMeta()) != null) {
            ArrayList<Component> list = new ArrayList<Component>();
            AdventureUtils.get(meta, "lore", new Class[0]).ifPresentOrElse(classMethod -> classMethod.invokeInstanceResulted(meta, new Object[0]).as(List.class).stream().map(ComponentUtils::componentFromPlatform).forEach(o -> list.add((Component)o)), () -> Objects.requireNonNull(meta.getLore()).stream().map(AdventureHelper::toComponent).forEach(list::add));
            list.add(component);
            this.itemLore(list);
        }
        return this;
    }

    @Override
    public boolean supportsMetadata(MetadataKey<?> key) {
        ItemMeta meta;
        if (this.item != null && (meta = this.item.getItemMeta()) != null) {
            return ItemMetaHelper.supportsMetadata(meta, key);
        }
        return false;
    }

    @Override
    public boolean supportsMetadata(MetadataCollectionKey<?> key) {
        ItemMeta meta;
        if (this.item != null && (meta = this.item.getItemMeta()) != null) {
            return ItemMetaHelper.supportsMetadata(meta, key);
        }
        return false;
    }

    @Override
    public <T> ItemBuilder setMetadata(MetadataKey<T> key, T value) {
        ItemMeta meta;
        if (this.item != null && (meta = this.item.getItemMeta()) != null) {
            ItemMetaHelper.setMetadata(meta, key, value);
            this.item.setItemMeta(meta);
        }
        return this;
    }

    @Override
    public <T> ItemBuilder setMetadata(MetadataCollectionKey<T> key, Collection<T> value) {
        ItemMeta meta;
        if (this.item != null && (meta = this.item.getItemMeta()) != null) {
            ItemMetaHelper.setMetadata(meta, key, value);
            this.item.setItemMeta(meta);
        }
        return this;
    }

    @Override
    public <T> ItemBuilder addToListMetadata(MetadataCollectionKey<T> key, T value) {
        ItemMeta meta;
        if (this.item != null && (meta = this.item.getItemMeta()) != null) {
            ItemMetaHelper.addMetadata(meta, key, value);
            this.item.setItemMeta(meta);
        }
        return this;
    }

    public BukkitItemBuilder(ItemStack item) {
        this.item = item;
    }
}

