/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.bukkit.item.data;

import com.google.common.primitives.Primitives;
import io.github.pronze.lib.screaminglib.item.data.ItemData;
import io.github.pronze.lib.screaminglib.utils.GsonUtils;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.meta.tags.CustomItemTagContainer;
import org.bukkit.inventory.meta.tags.ItemTagAdapterContext;
import org.bukkit.inventory.meta.tags.ItemTagType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitItemDataCustomTags
implements ItemData {
    private static final List<Class<?>> BASE_TAGS = List.of(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class, int[].class, byte[].class, long[].class);
    private final Plugin plugin;
    private final CustomItemTagContainer dataContainer;

    public static boolean isWrapperType(Class<?> clazz) {
        return BASE_TAGS.contains(clazz);
    }

    @Override
    public Set<String> getKeys() {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public <T> void set(String key, T data, Class<T> tClass) {
        if (!Primitives.isWrapperType(tClass)) {
            tClass = Primitives.wrap(tClass);
        }
        CustomItemTagContainer container = this.dataContainer;
        NamespacedKey namespacedKey = new NamespacedKey(this.plugin, key);
        if (BukkitItemDataCustomTags.isWrapperType(tClass)) {
            if (data instanceof String) {
                String s = (String)data;
                container.setCustomTag(namespacedKey, ItemTagType.STRING, (Object)s);
                return;
            }
            if (data instanceof Byte) {
                Byte s = (Byte)data;
                container.setCustomTag(namespacedKey, ItemTagType.BYTE, (Object)s);
                return;
            }
            if (data instanceof Short) {
                Short s = (Short)data;
                container.setCustomTag(namespacedKey, ItemTagType.SHORT, (Object)s);
                return;
            }
            if (data instanceof Integer) {
                Integer s = (Integer)data;
                container.setCustomTag(namespacedKey, ItemTagType.INTEGER, (Object)s);
                return;
            }
            if (data instanceof Long) {
                Long s = (Long)data;
                container.setCustomTag(namespacedKey, ItemTagType.LONG, (Object)s);
                return;
            }
            if (data instanceof Float) {
                Float s = (Float)data;
                container.setCustomTag(namespacedKey, ItemTagType.FLOAT, (Object)s);
                return;
            }
            if (data instanceof Double) {
                Double s = (Double)data;
                container.setCustomTag(namespacedKey, ItemTagType.DOUBLE, (Object)s);
                return;
            }
            if (data instanceof byte[]) {
                byte[] s = (byte[])data;
                container.setCustomTag(namespacedKey, ItemTagType.BYTE_ARRAY, (Object)s);
                return;
            }
            if (data instanceof int[]) {
                int[] s = (int[])data;
                container.setCustomTag(namespacedKey, ItemTagType.INTEGER_ARRAY, (Object)s);
                return;
            }
            if (data instanceof long[]) {
                long[] s = (long[])data;
                container.setCustomTag(namespacedKey, ItemTagType.LONG_ARRAY, (Object)s);
                return;
            }
            throw new UnsupportedOperationException("This stuff is not supported!");
        }
        container.setCustomTag(namespacedKey, new JsonPersistentDataType(tClass), data);
    }

    @Override
    @Nullable
    public <T> T get(String key, Class<T> tClass) {
        if (!Primitives.isWrapperType(tClass)) {
            tClass = Primitives.wrap(tClass);
        }
        CustomItemTagContainer container = this.dataContainer;
        NamespacedKey namespacedKey = new NamespacedKey(this.plugin, key);
        if (BukkitItemDataCustomTags.isWrapperType(tClass)) {
            if (String.class.isAssignableFrom(tClass)) {
                return (T)container.getCustomTag(namespacedKey, ItemTagType.STRING);
            }
            if (Byte.class.isAssignableFrom(tClass)) {
                return (T)container.getCustomTag(namespacedKey, ItemTagType.BYTE);
            }
            if (Short.class.isAssignableFrom(tClass)) {
                return (T)container.getCustomTag(namespacedKey, ItemTagType.SHORT);
            }
            if (Integer.class.isAssignableFrom(tClass)) {
                return (T)container.getCustomTag(namespacedKey, ItemTagType.INTEGER);
            }
            if (Long.class.isAssignableFrom(tClass)) {
                return (T)container.getCustomTag(namespacedKey, ItemTagType.LONG);
            }
            if (Float.class.isAssignableFrom(tClass)) {
                return (T)container.getCustomTag(namespacedKey, ItemTagType.FLOAT);
            }
            if (Double.class.isAssignableFrom(tClass)) {
                return (T)container.getCustomTag(namespacedKey, ItemTagType.DOUBLE);
            }
            if (byte[].class.isAssignableFrom(tClass)) {
                return (T)container.getCustomTag(namespacedKey, ItemTagType.BYTE_ARRAY);
            }
            if (int[].class.isAssignableFrom(tClass)) {
                return (T)container.getCustomTag(namespacedKey, ItemTagType.INTEGER_ARRAY);
            }
            if (long[].class.isAssignableFrom(tClass)) {
                return (T)container.getCustomTag(namespacedKey, ItemTagType.LONG_ARRAY);
            }
            throw new UnsupportedOperationException("This stuff is not supported!");
        }
        return (T)container.getCustomTag(namespacedKey, new JsonPersistentDataType(tClass));
    }

    @Override
    public <T> Optional<T> getOptional(String key, Class<T> tClass) {
        return Optional.ofNullable(this.get(key, tClass));
    }

    @Override
    public <T> T getOrDefault(String key, Class<T> tClass, Supplier<T> def) {
        return this.getOptional(key, tClass).orElse(def.get());
    }

    @Override
    public boolean contains(String key) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public boolean isEmpty() {
        return this.dataContainer.isEmpty();
    }

    public BukkitItemDataCustomTags(Plugin plugin, CustomItemTagContainer dataContainer) {
        this.plugin = plugin;
        this.dataContainer = dataContainer;
    }

    public CustomItemTagContainer getDataContainer() {
        return this.dataContainer;
    }

    public static class JsonPersistentDataType<T>
    implements ItemTagType<String, T> {
        private final Class<T> tClass;

        public JsonPersistentDataType(Class<T> tClass) {
            this.tClass = tClass;
        }

        @NotNull
        public Class<String> getPrimitiveType() {
            return String.class;
        }

        @NotNull
        public Class<T> getComplexType() {
            return this.tClass;
        }

        @NotNull
        public String toPrimitive(@NotNull T complex, @NotNull ItemTagAdapterContext context) {
            return GsonUtils.gson().toJson(complex);
        }

        @NotNull
        public T fromPrimitive(@NotNull String primitive, @NotNull ItemTagAdapterContext context) {
            return GsonUtils.gson().fromJson(primitive, this.tClass);
        }
    }
}

